/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.consumer.Consumer;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerThread
extends Thread {
    private Object lock = new Object();
    private static final long[] expoSeq = new long[]{3L, 5L, 8L, 13L, 21L, 34L, 55L};
    private AtomicBoolean running = new AtomicBoolean(false);
    private Consumer consumer;
    private Logger log;

    public ConsumerThread(Consumer consumer) {
        super(consumer.getName());
        this.consumer = consumer;
        this.log = LoggerFactory.getLogger((String)("consumer-thread-" + consumer.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running.set(true);
        int connectAttempt = 0;
        do {
            LocalDateTime lastConnectAttemptTime = LocalDateTime.now();
            this.log.info("starting consumer");
            try {
                this.consumer.listen();
            }
            catch (Exception e) {
                this.log.debug("Couldn't get connection", (Throwable)e);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.running.get()) {
                    if (LocalDateTime.now().isAfter(lastConnectAttemptTime.plus(expoSeq[expoSeq.length - 1], ChronoUnit.SECONDS))) {
                        connectAttempt = 0;
                    }
                    try {
                        this.log.info("unexpected consumer shutdown - trying reconnect in {} seconds", (Object)expoSeq[connectAttempt]);
                        this.lock.wait(expoSeq[connectAttempt] * 1000L);
                        connectAttempt = Math.min(connectAttempt + 1, expoSeq.length - 1);
                    }
                    catch (InterruptedException ignored) {
                        this.log.error("", (Throwable)ignored);
                    }
                }
            }
        } while (this.running.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            this.consumer.shutdown();
            this.running.set(false);
        }
    }
}

