/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.consumer.MessageRunnable;
import forklift.consumer.ProcessStep;
import forklift.decorators.LifeCycle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleMonitors {
    private static final Logger log = LoggerFactory.getLogger(LifeCycleMonitors.class);
    private static AtomicInteger calls = new AtomicInteger(0);
    private static final Map<ProcessStep, List<Monitor>> monitors = new HashMap<ProcessStep, List<Monitor>>();

    public static void register(Class<?> clazz) {
        LifeCycleMonitors.register(clazz, null);
    }

    public static void register(Object existingInstance) {
        LifeCycleMonitors.register(existingInstance.getClass(), existingInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(Class<?> clazz, Object existingInstance) {
        Map<ProcessStep, List<Monitor>> map = monitors;
        synchronized (map) {
            while (calls.get() > 0) {
                try {
                    monitors.wait(10L);
                }
                catch (InterruptedException ignored) {}
            }
            if (calls.get() != 0) {
                throw new RuntimeException("Registering LifeCycleMonitor during active call.");
            }
            Object instance = existingInstance;
            for (Method m : clazz.getDeclaredMethods()) {
                boolean staticMethod = Modifier.isStatic(m.getModifiers());
                if (!staticMethod && instance == null) {
                    try {
                        if (existingInstance == null) {
                            instance = clazz.newInstance();
                        }
                    }
                    catch (Exception ignored) {
                        log.error("", (Throwable)ignored);
                        return;
                    }
                }
                for (LifeCycle a : (LifeCycle[])m.getAnnotationsByType(LifeCycle.class)) {
                    log.info("Adding Monitor.... {}-{}", clazz, (Object)a);
                    m.setAccessible(true);
                    Monitor monitor = new Monitor();
                    monitor.clazz = clazz;
                    monitor.method = m;
                    if (!staticMethod) {
                        monitor.instance = instance;
                    }
                    LifeCycle lifeCycle = a;
                    monitor.annotation = lifeCycle.annotation();
                    monitors.get((Object)lifeCycle.value()).add(monitor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(Class<?> clazz) {
        Map<ProcessStep, List<Monitor>> map = monitors;
        synchronized (map) {
            while (calls.get() > 0) {
                try {
                    monitors.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (calls.get() != 0) {
                throw new RuntimeException("Registering LifeCycleMonitor during active call.");
            }
            monitors.values().stream().forEach(list -> {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Monitor monitor = (Monitor)it.next();
                    if (monitor.clazz != clazz) continue;
                    log.info("Removing Monitor.... {}-{}", monitor.clazz, (Object)monitor.method);
                    it.remove();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void call(ProcessStep step, MessageRunnable mr) {
        if (calls.get() == 0) {
            Map<ProcessStep, List<Monitor>> map = monitors;
            synchronized (map) {
                calls.incrementAndGet();
            }
        } else {
            calls.incrementAndGet();
        }
        try {
            monitors.keySet().stream().filter(key -> key == step).map(key -> monitors.get(key)).forEach(list -> list.forEach(monitor -> {
                try {
                    if (monitor.annotation == Annotation.class || mr.getConsumer().getMsgHandler().isAnnotationPresent(monitor.annotation)) {
                        if (monitor.method.getParameterCount() == 1) {
                            monitor.method.invoke(monitor.instance, mr);
                        } else {
                            monitor.method.invoke(monitor.instance, mr, mr.getConsumer().getMsgHandler().getAnnotation(monitor.annotation));
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("Error invoking LifeCycle Monitor", e);
                }
            }));
        }
        finally {
            calls.decrementAndGet();
        }
    }

    public static Integer getCalls() {
        return calls.get();
    }

    static {
        monitors.put(ProcessStep.Pending, new ArrayList());
        monitors.put(ProcessStep.Validating, new ArrayList());
        monitors.put(ProcessStep.Invalid, new ArrayList());
        monitors.put(ProcessStep.Processing, new ArrayList());
        monitors.put(ProcessStep.Retrying, new ArrayList());
        monitors.put(ProcessStep.MaxRetriesExceeded, new ArrayList());
        monitors.put(ProcessStep.Error, new ArrayList());
        monitors.put(ProcessStep.Complete, new ArrayList());
    }

    private static class Monitor {
        Class<?> clazz;
        Method method;
        Object instance;
        Class<? extends Annotation> annotation;

        private Monitor() {
        }
    }
}

