/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.classloader.RunAsClassLoader;
import forklift.connectors.ForkliftMessage;
import forklift.consumer.Consumer;
import forklift.consumer.LifeCycleMonitors;
import forklift.consumer.ProcessStep;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MessageRunnable.class);
    private Consumer consumer;
    private ForkliftMessage msg;
    private ClassLoader classLoader;
    private Object handler;
    private List<Method> onMessage;
    private List<Method> onValidate;
    private Map<ProcessStep, List<Method>> onProcessStep;
    private List<String> errors;

    MessageRunnable(Consumer consumer, ForkliftMessage msg, ClassLoader classLoader, Object handler, List<Method> onMessage, List<Method> onValidate, Map<ProcessStep, List<Method>> onProcessStep) {
        this.consumer = consumer;
        this.msg = msg;
        this.classLoader = classLoader;
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.handler = handler;
        this.onMessage = onMessage;
        this.onValidate = onValidate;
        this.onProcessStep = onProcessStep;
        this.errors = new ArrayList<String>();
        LifeCycleMonitors.call(ProcessStep.Pending, this);
    }

    @Override
    public void run() {
        RunAsClassLoader.run(this.classLoader, () -> {
            this.runHooks(ProcessStep.Validating);
            LifeCycleMonitors.call(ProcessStep.Validating, this);
            for (Method m : this.onValidate) {
                if (m.getReturnType() == List.class) {
                    this.addError(this.runLoggingErrors(() -> (List)m.invoke(this.handler, new Object[0])));
                    continue;
                }
                if (m.getReturnType() == Boolean.TYPE) {
                    boolean valid = this.runLoggingErrors(() -> (boolean)((Boolean)m.invoke(this.handler, new Object[0])));
                    if (valid) continue;
                    this.addError("Validator " + m.getName() + " returned false");
                    continue;
                }
                this.addError("onValidate method " + m.getName() + " has wrong return type " + m.getReturnType());
            }
            if (this.errors.size() > 0) {
                this.runHooks(ProcessStep.Invalid);
                LifeCycleMonitors.call(ProcessStep.Invalid, this);
            } else {
                this.runHooks(ProcessStep.Processing);
                LifeCycleMonitors.call(ProcessStep.Processing, this);
                for (Method m : this.onMessage) {
                    this.runLoggingErrors(() -> m.invoke(this.handler, new Object[0]));
                }
                if (this.errors.size() > 0) {
                    this.runHooks(ProcessStep.Error);
                    LifeCycleMonitors.call(ProcessStep.Error, this);
                } else {
                    this.runHooks(ProcessStep.Complete);
                    LifeCycleMonitors.call(ProcessStep.Complete, this);
                }
            }
            this.getErrors().stream().forEach(e -> log.error(e));
            try {
                this.msg.getJmsMsg().acknowledge();
            }
            catch (JMSException e2) {
                log.error("Error while acking message.", (Throwable)e2);
            }
        });
    }

    public void addError(List<String> errors) {
        if (errors == null) {
            return;
        }
        this.errors.addAll(errors);
    }

    public void addError(String e) {
        this.errors.add(e);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ForkliftMessage getMsg() {
        return this.msg;
    }

    public Object getHandler() {
        return this.handler;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    private <T> T runLoggingErrors(DangerousSupplier<T> func) {
        try {
            return func.get();
        }
        catch (Throwable e) {
            if (e.getCause() == null) {
                this.addError(e.getMessage());
            } else {
                this.addError(e.getCause().getMessage());
            }
            return null;
        }
    }

    private void runHooks(ProcessStep step) {
        for (Method m : this.onProcessStep.get((Object)step)) {
            this.runLoggingErrors(() -> m.invoke(this.handler, new Object[0]));
        }
    }

    @FunctionalInterface
    private static interface DangerousSupplier<T> {
        public T get() throws Throwable;
    }
}

