/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.Forklift;
import forklift.classloader.CoreClassLoaders;
import forklift.classloader.RunAsClassLoader;
import forklift.concurrent.Executors;
import forklift.consumer.Consumer;
import forklift.consumer.ConsumerThread;
import forklift.deployment.Deployment;
import forklift.deployment.DeploymentEvents;
import forklift.spring.ContextManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

public class ConsumerDeploymentEvents
implements DeploymentEvents {
    private static final Logger log = LoggerFactory.getLogger(ConsumerDeploymentEvents.class);
    private final Map<Deployment, List<ConsumerThread>> deployments = new HashMap<Deployment, List<ConsumerThread>>();
    private final Forklift forklift;
    private final ExecutorService executor;

    public ConsumerDeploymentEvents(Forklift forklift, ExecutorService executor) {
        this.forklift = forklift;
        this.executor = executor;
    }

    public ConsumerDeploymentEvents(Forklift forklift) {
        this(forklift, Executors.newCoreThreadPool("consumer-deployment-events"));
    }

    @Override
    public synchronized void onDeploy(Deployment deployment) {
        log.info("Deploying: " + deployment);
        ArrayList threads = new ArrayList();
        RunAsClassLoader.run(deployment.getClassLoader(), () -> {
            Set springConfigs = deployment.getReflections().getTypesAnnotatedWith(Configuration.class);
            if (springConfigs.size() > 0) {
                ContextManager.start(deployment.getDeployedFile().getName(), (Class[])springConfigs.toArray());
            }
        });
        ApplicationContext context = ContextManager.getContext(deployment.getDeployedFile().getName());
        deployment.getQueues().forEach(c -> {
            ConsumerThread thread = new ConsumerThread(new Consumer((Class<?>)c, this.forklift.getConnector(), deployment.getClassLoader(), context));
            threads.add(thread);
            this.executor.submit(thread);
        });
        deployment.getTopics().forEach(c -> {
            ConsumerThread thread = new ConsumerThread(new Consumer((Class<?>)c, this.forklift.getConnector(), deployment.getClassLoader(), context));
            threads.add(thread);
            this.executor.submit(thread);
        });
        this.deployments.put(deployment, threads);
    }

    @Override
    public synchronized void onUndeploy(Deployment deployment) {
        log.info("Undeploying: " + deployment);
        List<ConsumerThread> threads = this.deployments.remove(deployment);
        if (threads != null && !threads.isEmpty()) {
            threads.forEach(t -> {
                t.shutdown();
                try {
                    t.join(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        ContextManager.stop(deployment.getDeployedFile().getName());
        CoreClassLoaders.getInstance().unregister(deployment.getClassLoader());
    }

    @Override
    public boolean filter(Deployment deployment) {
        log.info("Filtering: " + deployment);
        return deployment.getDeployedFile().getName().endsWith(".jar") || deployment.getDeployedFile().getName().endsWith(".zip");
    }
}

