/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.classloader.RunAsClassLoader;
import forklift.connectors.ForkliftMessage;
import forklift.consumer.Consumer;
import forklift.consumer.LifeCycleMonitors;
import forklift.consumer.ProcessStep;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MessageRunnable.class);
    private Consumer consumer;
    private ForkliftMessage msg;
    private ClassLoader classLoader;
    private Object handler;
    private List<Method> onMessage;
    private List<Method> onValidate;
    private List<String> errors;
    private boolean error = false;

    MessageRunnable(Consumer consumer, ForkliftMessage msg, ClassLoader classLoader, Object handler, List<Method> onMessage, List<Method> onValidate) {
        this.consumer = consumer;
        this.msg = msg;
        this.classLoader = classLoader;
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.handler = handler;
        this.onMessage = onMessage;
        this.onValidate = onValidate;
        this.errors = new ArrayList<String>();
        LifeCycleMonitors.call(ProcessStep.Pending, this);
    }

    @Override
    public void run() {
        RunAsClassLoader.run(this.classLoader, () -> {
            try {
                try {
                    LifeCycleMonitors.call(ProcessStep.Validating, this);
                    for (Method m : this.onValidate) {
                        if (m.getReturnType() == List.class) {
                            this.addError((List)m.invoke(this.handler, new Object[0]));
                            continue;
                        }
                        if (m.getReturnType() == Boolean.TYPE) {
                            this.error = this.error || (Boolean)m.invoke(this.handler, new Object[0]) == false;
                            continue;
                        }
                        this.addError("Return type of " + m.getReturnType() + " is not supported for OnValidate methods");
                    }
                    if (this.error) {
                        LifeCycleMonitors.call(ProcessStep.Invalid, this);
                    } else {
                        LifeCycleMonitors.call(ProcessStep.Processing, this);
                        for (Method m : this.onMessage) {
                            m.invoke(this.handler, new Object[0]);
                        }
                    }
                }
                catch (Throwable e2) {
                    log.info("Error processing", e2);
                    if (e2.getCause() != null) {
                        this.addError(e2.getCause().getMessage());
                    } else {
                        this.addError(e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (this.error) {
                        this.getErrors().stream().forEach(e -> log.error(e));
                        LifeCycleMonitors.call(ProcessStep.Error, this);
                    } else {
                        LifeCycleMonitors.call(ProcessStep.Complete, this);
                    }
                    this.msg.getJmsMsg().acknowledge();
                }
                catch (JMSException e3) {
                    log.error("Error while acking messgae.", (Throwable)e3);
                }
            }
        });
    }

    public void addError(List<String> errors) {
        if (errors == null) {
            return;
        }
        this.errors.addAll(errors);
        if (this.errors.size() > 0) {
            this.setError();
        }
    }

    public void addError(String e) {
        this.errors.add(e);
        this.setError();
    }

    public void setError() {
        this.error = true;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ForkliftMessage getMsg() {
        return this.msg;
    }

    public Object getHandler() {
        return this.handler;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }
}

