/*
 * Decompiled with CFR 0.152.
 */
package forklift.deployment;

import forklift.deployment.Deployment;
import forklift.deployment.DeploymentEvents;
import forklift.deployment.DeploymentManager;
import forklift.file.FileScanResult;
import forklift.file.FileScanner;
import forklift.file.FileStatus;
import forklift.properties.PropertiesManager;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DeploymentWatch
implements Runnable {
    private FileScanner fileScan;
    private DeploymentEvents events;
    private DeploymentManager deploymentManager;
    private PropertiesManager properties;

    public DeploymentWatch(File dir, DeploymentEvents events) {
        this.events = events;
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("A directory must be specified to watch");
        }
        this.fileScan = new FileScanner(dir);
        this.deploymentManager = new DeploymentManager();
        this.properties = new PropertiesManager();
    }

    @Override
    public synchronized void run() {
        List<FileScanResult> results = this.fileScan.scan();
        for (FileScanResult result : results) {
            File file = new File(this.fileScan.getDir(), result.getFilename());
            boolean jar = file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            boolean props = file.getName().endsWith(".properties");
            if (result.getStatus() == FileStatus.Removed || result.getStatus() == FileStatus.Modified) {
                if (jar) {
                    this.events.onUndeploy(this.deploymentManager.unregisterDeployedFile(file));
                } else if (props) {
                    this.properties.deregister(file);
                }
            }
            if (result.getStatus() != FileStatus.Added && result.getStatus() != FileStatus.Modified) continue;
            try {
                if (jar) {
                    this.events.onDeploy(this.deploymentManager.registerDeployedFile(file));
                    continue;
                }
                if (!props) continue;
                this.properties.register(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void shutdown() {
        this.deploymentManager.getAll().stream().forEach(deploy -> this.events.onUndeploy((Deployment)deploy));
    }
}

