/*
 * Decompiled with CFR 0.152.
 */
package forklift.file;

import forklift.file.FileScanResult;
import forklift.file.FileStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileScanner {
    private long lastScan = Long.MIN_VALUE;
    private Map<String, Object> files = new HashMap<String, Object>();
    private Object placeHolder = new Object();
    private File dir;

    public FileScanner(File dir) {
        this.dir = dir;
    }

    public List<FileScanResult> scan() {
        ArrayList<FileScanResult> results = new ArrayList<FileScanResult>();
        for (String filename : this.dir.list()) {
            boolean changed;
            File file = new File(this.dir, filename);
            if (file.isDirectory()) continue;
            boolean bl = changed = file.lastModified() > this.lastScan;
            if (this.files.containsKey(filename)) {
                if (changed) {
                    results.add(new FileScanResult(FileStatus.Modified, filename));
                    continue;
                }
                results.add(new FileScanResult(FileStatus.Unchanged, filename));
                continue;
            }
            results.add(new FileScanResult(FileStatus.Added, filename));
            this.files.put(filename, this.placeHolder);
        }
        Iterator<String> it = this.files.keySet().iterator();
        while (it.hasNext()) {
            String filename = it.next();
            if (results.contains(new FileScanResult(FileStatus.Unchanged, filename)) || results.contains(new FileScanResult(FileStatus.Added, filename)) || results.contains(new FileScanResult(FileStatus.Modified, filename))) continue;
            it.remove();
            results.add(new FileScanResult(FileStatus.Removed, filename));
        }
        this.lastScan = System.currentTimeMillis();
        return results;
    }

    public File getDir() {
        return this.dir;
    }

    public long getLastScanTime() {
        return this.lastScan;
    }
}

