/*
 * Decompiled with CFR 0.152.
 */
package forklift.properties;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesManager {
    private static final Logger log = LoggerFactory.getLogger(PropertiesManager.class);
    private static final Map<String, Properties> deployments = new HashMap<String, Properties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(File deployment) {
        log.info("Deploying: " + deployment);
        if (!deployment.getName().endsWith(".properties")) {
            log.warn("Invalid properties file.");
            return;
        }
        FileReader fr = null;
        try {
            fr = new FileReader(deployment);
            Properties props = new Properties();
            props.load(fr);
            Map<String, Properties> map = deployments;
            synchronized (map) {
                deployments.put(this.getName(deployment), props);
            }
        }
        catch (IOException e) {
            log.warn("File didn't exist while attempting to read.");
            return;
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid properties file, please check syntax.");
            return;
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(File deployment) {
        log.info("Undeploying: " + deployment);
        Map<String, Properties> map = deployments;
        synchronized (map) {
            deployments.remove(this.getName(deployment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties get(String name) {
        Map<String, Properties> map = deployments;
        synchronized (map) {
            return deployments.get(name);
        }
    }

    private String getName(File f) {
        return f.getName().split("\\.")[0];
    }
}

