/*
 * Decompiled with CFR 0.152.
 */
package forklift.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class ContextManager {
    private static final String DEFAULT = "default-context";
    private static Map<String, ApplicationContext> contexts = new HashMap<String, ApplicationContext>();

    public static synchronized ApplicationContext start(Class<?> ... clazzes) {
        contexts.put(DEFAULT, (ApplicationContext)new AnnotationConfigApplicationContext((Class[])clazzes));
        return ContextManager.getContext(DEFAULT);
    }

    public static synchronized ApplicationContext start(ApplicationContext ctx) {
        contexts.put(DEFAULT, ctx);
        return ctx;
    }

    public static synchronized ApplicationContext start(String name, Class<?> ... clazzes) {
        contexts.put(name, (ApplicationContext)new AnnotationConfigApplicationContext((Class[])clazzes));
        return ContextManager.getContext(name);
    }

    public static synchronized ApplicationContext getContext() {
        return contexts.get(DEFAULT);
    }

    public static synchronized ApplicationContext getContext(String name) {
        return contexts.get(name);
    }

    public static synchronized void stop() {
        ContextManager.stop(DEFAULT);
    }

    public static synchronized void stop(String name) {
        GenericApplicationContext context = (GenericApplicationContext)contexts.remove(name);
        if (context != null) {
            context.close();
        }
    }

    public static synchronized void fullStop() {
        ArrayList<String> names = new ArrayList<String>();
        for (String key : contexts.keySet()) {
            names.add(key);
        }
        for (String name : names) {
            ContextManager.stop(name);
        }
    }
}

