/*
 * Decompiled with CFR 0.152.
 */
package forklift.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Executors {
    private static final int cpus = Runtime.getRuntime().availableProcessors();

    private Executors() {
    }

    private static ThreadFactory daemonThreadFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(name + "-" + this.counter.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static ExecutorService newCoreThreadPool(String name) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(2 * cpus, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Executors.daemonThreadFactory(name));
        pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return pool;
    }
}

