/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer.wrapper;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import forklift.connectors.ConnectorException;
import forklift.connectors.ForkliftMessage;
import forklift.message.Header;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleInputMessage {
    private static final Logger log = LoggerFactory.getLogger(RoleInputMessage.class);
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private String role;
    private String id;
    private String msg;
    private Map<String, String> properties;
    private Map<Header, Object> headers;

    @JsonCreator
    public RoleInputMessage(@JsonProperty(value="role") String role, @JsonProperty(value="id") String id, @JsonProperty(value="msg") String msg, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="headers") Map<Header, Object> headers) {
        this.role = role;
        this.id = id;
        this.msg = msg;
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
        if (headers != null) {
            this.headers = new HashMap<Header, Object>(headers);
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getId() {
        return this.id;
    }

    public String getMsg() {
        return this.msg;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<Header, Object> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleInputMessage)) {
            return false;
        }
        RoleInputMessage that = (RoleInputMessage)o;
        return Objects.equals(this.role, that.role) && Objects.equals(this.id, that.id) && Objects.equals(this.msg, that.msg) && Objects.equals(this.properties, that.properties) && Objects.equals(this.headers, that.headers);
    }

    public static RoleInputMessage fromString(String input) {
        try {
            return (RoleInputMessage)mapper.readValue(input, RoleInputMessage.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not deserialize RoleInputMessage from JSON: " + input);
        }
    }

    public static RoleInputMessage fromForkliftMessage(String role, ForkliftMessage input) {
        return new RoleInputMessage(role, input.getId(), input.getMsg(), input.getProperties(), input.getHeaders());
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            log.error("Could not serialize RoleInputMessage", (Throwable)e);
            return null;
        }
    }

    public ForkliftMessage toForkliftMessage(ForkliftMessage sourceMessage) {
        AcknowledgingMessage result = new AcknowledgingMessage(sourceMessage);
        if (this.id != null) {
            result.setId(this.id);
        }
        if (this.msg != null) {
            result.setMsg(this.msg);
        }
        if (this.properties != null) {
            result.setProperties(this.properties);
        }
        if (this.headers != null) {
            result.setHeaders(this.headers);
        }
        return result;
    }

    private static class AcknowledgingMessage
    extends ForkliftMessage {
        private ForkliftMessage sourceMessage;

        public AcknowledgingMessage(ForkliftMessage sourceMessage) {
            this.sourceMessage = sourceMessage;
        }

        @Override
        public boolean acknowledge() throws ConnectorException {
            if (this.sourceMessage == null) {
                return true;
            }
            return this.sourceMessage.acknowledge();
        }
    }
}

