/*
 * Decompiled with CFR 0.152.
 */
package forklift.deployment;

import com.google.common.base.Preconditions;
import forklift.decorators.CoreService;
import forklift.decorators.Service;
import forklift.deployment.Deployment;
import forklift.source.SourceUtil;
import java.util.HashSet;
import java.util.Set;

public class ClassDeployment
implements Deployment {
    private Set<Class<?>> consumers = new HashSet();
    private Set<Class<?>> services = new HashSet();
    private Set<Class<?>> coreServices = new HashSet();

    public ClassDeployment(Class<?> ... deploymentClasses) {
        Preconditions.checkNotNull(deploymentClasses);
        for (Class<?> c : deploymentClasses) {
            if (c.isAnnotationPresent(CoreService.class)) {
                this.coreServices.add(c);
            }
            if (c.isAnnotationPresent(Service.class)) {
                this.services.add(c);
            }
            if (!SourceUtil.hasSourceAnnotation(c)) continue;
            this.consumers.add(c);
        }
    }

    @Override
    public Set<Class<?>> getCoreServices() {
        return this.coreServices;
    }

    @Override
    public Set<Class<?>> getServices() {
        return this.services;
    }

    @Override
    public Set<Class<?>> getConsumers() {
        return this.consumers;
    }

    @Override
    public ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDeployment that = (ClassDeployment)o;
        if (!this.consumers.equals(that.consumers)) {
            return false;
        }
        if (!this.services.equals(that.services)) {
            return false;
        }
        return this.coreServices.equals(that.coreServices);
    }

    public int hashCode() {
        int result = this.consumers.hashCode();
        result = 31 * result + this.services.hashCode();
        result = 31 * result + this.coreServices.hashCode();
        return result;
    }

    private boolean identicalSets(Set<?> set1, Set<?> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }
}

