/*
 * Decompiled with CFR 0.152.
 */
package forklift.deployment;

import forklift.classloader.ChildFirstClassLoader;
import forklift.classloader.RunAsClassLoader;
import forklift.decorators.CoreService;
import forklift.decorators.Service;
import forklift.deployment.Deployment;
import forklift.source.SourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class FileDeployment
implements Deployment {
    private Set<Class<?>> consumers = new HashSet();
    private Set<Class<?>> services = new HashSet();
    private Set<Class<?>> coreServices = new HashSet();
    private ClassLoader cl;
    private File deployedFile;
    private Reflections reflections;

    public FileDeployment() {
    }

    public FileDeployment(File deployedFile) throws IOException {
        if (deployedFile == null) {
            throw new IOException("Missing file");
        }
        this.deployedFile = deployedFile;
        if (!deployedFile.getName().endsWith(".jar") && !deployedFile.getName().endsWith(".zip")) {
            throw new IOException("Unhandled file type");
        }
        JarFile jar = new JarFile(deployedFile);
        List<URL> jarUrls = jar.stream().filter(entry -> entry.getName().endsWith(".jar") || entry.getName().endsWith(".zip")).map(entry -> {
            try {
                return FileDeployment.jarEntryAsUri(jar, entry).toURL();
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        jarUrls.add(deployedFile.toURI().toURL());
        URL[] urls = jarUrls.toArray(new URL[0]);
        this.cl = new ChildFirstClassLoader(urls, this.getClass().getClassLoader());
        SourceUtil.SourceTypeScanner sourceScanner = new SourceUtil.SourceTypeScanner(this.cl);
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(this.cl).setUrls(urls).addScanners(new Scanner[]{sourceScanner}));
        RunAsClassLoader.run(this.cl, () -> {
            this.coreServices.addAll(this.reflections.getTypesAnnotatedWith(CoreService.class));
            this.services.addAll(this.reflections.getTypesAnnotatedWith(Service.class));
            this.consumers = sourceScanner.getSourceAnnotatedTypes();
        });
        if (this.coreServices.size() > 0 && (this.consumers.size() > 0 || this.services.size() > 0)) {
            throw new IOException("Invalid core service due to consumers/services being deployed along side.");
        }
    }

    public boolean isJar() {
        return this.deployedFile.getPath().endsWith(".jar");
    }

    public boolean isClass() {
        return this.deployedFile.getPath().endsWith(".class");
    }

    public File getDeployedFile() {
        return this.deployedFile;
    }

    public void setDeployedFile(File deployedFile) {
        this.deployedFile = deployedFile;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @Override
    public Set<Class<?>> getCoreServices() {
        return this.coreServices;
    }

    @Override
    public Set<Class<?>> getServices() {
        return this.services;
    }

    @Override
    public Set<Class<?>> getConsumers() {
        return this.consumers;
    }

    public Reflections getReflections() {
        return this.reflections;
    }

    public boolean equals(Object o) {
        return ((FileDeployment)o).getDeployedFile().equals(this.deployedFile);
    }

    public String toString() {
        return "FileDeployment [consumers=" + this.consumers + ", cl=" + this.cl + ", deployedFile=" + this.deployedFile + ", reflections=" + this.reflections + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI jarEntryAsUri(JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarFile == null || jarEntry == null) {
            throw new IOException("Invalid jar file or entry");
        }
        InputStream input = null;
        OutputStream output = null;
        try {
            int readCount;
            String name = jarEntry.getName().replace('/', '_');
            int i = name.lastIndexOf(".");
            String extension = i > -1 ? name.substring(i) : "";
            File file = File.createTempFile(name.substring(0, name.length() - extension.length()) + ".", extension);
            file.deleteOnExit();
            input = jarFile.getInputStream(jarEntry);
            output = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) != -1) {
                output.write(buffer, 0, readCount);
            }
            URI uRI = file.toURI();
            return uRI;
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }
}

