/*
 * Decompiled with CFR 0.152.
 */
package forklift.producers;

import forklift.connectors.ForkliftMessage;
import forklift.message.Header;
import forklift.producers.ForkliftProducerI;
import forklift.producers.ForkliftResultResolver;
import forklift.producers.ForkliftSyncProducerI;
import forklift.producers.ProducerException;
import forklift.producers.ResultFuture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;

public class ForkliftSyncProducer<T>
implements ForkliftSyncProducerI<T> {
    private ForkliftProducerI producer;
    private ForkliftResultResolver<T> resolver;
    private URI uri;

    public ForkliftSyncProducer(ForkliftProducerI producer, ForkliftResultResolver<T> resolver, String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.producer = producer;
        try {
            this.producer.setProperties(new HashMap<String, String>());
            this.producer.getProperties().put("@ResponseUri", this.uri.toString());
            this.resolver = resolver;
        }
        catch (ProducerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<T> send(String message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Future<T> send(ForkliftMessage message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Future<T> send(Object message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Future<T> send(Map<String, String> message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Future<T> send(Map<Header, Object> headers, Map<String, String> properties, ForkliftMessage message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Future<T> send(Map<String, String> properties, ForkliftMessage message) throws ProducerException {
        return this.resolver.register(new ResultFuture(this.producer.send(message)));
    }

    @Override
    public Map<Header, Object> getHeaders() throws ProducerException {
        return this.producer.getHeaders();
    }

    @Override
    public void setHeaders(Map<Header, Object> headers) throws ProducerException {
        this.producer.setHeaders(headers);
    }

    @Override
    public Map<String, String> getProperties() throws ProducerException {
        return this.producer.getProperties();
    }

    @Override
    public void setProperties(Map<String, String> properties) throws ProducerException {
        this.producer.setProperties(properties);
    }

    @Override
    public void close() {
        try {
            this.producer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

