/*
 * Decompiled with CFR 0.152.
 */
package forklift.source.sources;

import forklift.source.ActionSource;
import forklift.source.decorators.GroupedTopic;
import java.util.Objects;

public class GroupedTopicSource
extends ActionSource {
    private final String name;
    private String group;

    public GroupedTopicSource(String name, String group) {
        this.name = name;
        this.group = group;
    }

    public GroupedTopicSource(GroupedTopic topic) {
        this.name = topic.name();
        this.group = topic.group();
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean groupSpecified() {
        return this.group != null && !this.group.isEmpty();
    }

    public void overrideGroup(String group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupedTopicSource)) {
            return false;
        }
        GroupedTopicSource that = (GroupedTopicSource)o;
        return Objects.equals(this.name, that.name);
    }

    public String toString() {
        return "GroupedTopicSource(name=" + this.name + ", group=" + this.group + ")";
    }
}

