/*
 * Decompiled with CFR 0.152.
 */
package forklift.source.sources;

import forklift.source.ActionSource;
import forklift.source.LogicalSource;
import forklift.source.LogicalSourceContext;
import forklift.source.decorators.RoleInput;
import java.util.Objects;

public class RoleInputSource
extends LogicalSource {
    private String role;

    public RoleInputSource(String role) {
        this.role = role;
    }

    public RoleInputSource(RoleInput roleInput) {
        this.role = roleInput.role();
    }

    @Override
    protected void onContextSet() {
        if (!this.isRoleDefined()) {
            this.role = this.getContextClass().getSimpleName();
        }
    }

    public boolean isRoleDefined() {
        return this.role != null && !this.role.isEmpty();
    }

    public String getRole() {
        if (!this.isRoleDefined()) {
            return null;
        }
        return this.role;
    }

    @Override
    public ActionSource getActionSource(LogicalSourceContext context) {
        return context.mapSource(this);
    }

    public String toString() {
        return "RoleInputSource(role=" + this.getRole() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleInputSource)) {
            return false;
        }
        RoleInputSource that = (RoleInputSource)o;
        return Objects.equals(this.getRole(), that.getRole());
    }
}

