/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.consumer.MessageRunnable;
import forklift.consumer.ProcessStep;
import forklift.decorators.LifeCycle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleMonitors {
    private static final Logger log = LoggerFactory.getLogger(LifeCycleMonitors.class);
    private AtomicInteger calls = new AtomicInteger(0);
    private final Map<ProcessStep, List<Monitor>> monitors = new HashMap<ProcessStep, List<Monitor>>();

    public LifeCycleMonitors() {
        this.monitors.put(ProcessStep.Pending, new ArrayList());
        this.monitors.put(ProcessStep.Validating, new ArrayList());
        this.monitors.put(ProcessStep.Invalid, new ArrayList());
        this.monitors.put(ProcessStep.Processing, new ArrayList());
        this.monitors.put(ProcessStep.Retrying, new ArrayList());
        this.monitors.put(ProcessStep.MaxRetriesExceeded, new ArrayList());
        this.monitors.put(ProcessStep.Error, new ArrayList());
        this.monitors.put(ProcessStep.Complete, new ArrayList());
    }

    public void register(Class<?> clazz) {
        this.register(clazz, null);
    }

    public void register(Object existingInstance) {
        this.register(existingInstance.getClass(), existingInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Class<?> clazz, Object existingInstance) {
        Map<ProcessStep, List<Monitor>> map = this.monitors;
        synchronized (map) {
            while (this.calls.get() > 0) {
                try {
                    this.monitors.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.calls.get() != 0) {
                throw new RuntimeException("Registering LifeCycleMonitor during active call.");
            }
            Object instance = existingInstance;
            for (Method m : clazz.getDeclaredMethods()) {
                boolean staticMethod = Modifier.isStatic(m.getModifiers());
                if (!staticMethod && instance == null) {
                    try {
                        if (existingInstance == null) {
                            instance = clazz.newInstance();
                        }
                    }
                    catch (Exception ignored) {
                        log.error("", (Throwable)ignored);
                        return;
                    }
                }
                for (LifeCycle a : (LifeCycle[])m.getAnnotationsByType(LifeCycle.class)) {
                    log.info("Adding Monitor.... {}-{}", clazz, (Object)a);
                    m.setAccessible(true);
                    Monitor monitor = new Monitor();
                    monitor.clazz = clazz;
                    monitor.method = m;
                    if (!staticMethod) {
                        monitor.instance = instance;
                    }
                    LifeCycle lifeCycle = a;
                    monitor.annotation = lifeCycle.annotation();
                    this.monitors.get((Object)lifeCycle.value()).add(monitor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Class<?> clazz) {
        Map<ProcessStep, List<Monitor>> map = this.monitors;
        synchronized (map) {
            while (this.calls.get() > 0) {
                try {
                    this.monitors.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.calls.get() != 0) {
                throw new RuntimeException("Registering LifeCycleMonitor during active call.");
            }
            this.monitors.values().stream().forEach(list -> {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Monitor monitor = (Monitor)it.next();
                    if (monitor.clazz != clazz) continue;
                    log.info("Removing Monitor.... {}-{}", monitor.clazz, (Object)monitor.method);
                    it.remove();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(ProcessStep step, MessageRunnable mr) {
        if (this.calls.get() == 0) {
            Map<ProcessStep, List<Monitor>> map = this.monitors;
            synchronized (map) {
                this.calls.incrementAndGet();
            }
        } else {
            this.calls.incrementAndGet();
        }
        try {
            this.monitors.keySet().stream().filter(key -> key == step).map(key -> this.monitors.get(key)).forEach(list -> list.forEach(monitor -> {
                try {
                    if (monitor.annotation == Annotation.class || mr.getConsumer().getMsgHandler().isAnnotationPresent(monitor.annotation)) {
                        if (monitor.method.getParameterCount() == 1) {
                            monitor.method.invoke(monitor.instance, mr);
                        } else {
                            monitor.method.invoke(monitor.instance, mr, mr.getConsumer().getMsgHandler().getAnnotation(monitor.annotation));
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("Error invoking LifeCycle Monitor", e);
                }
            }));
        }
        finally {
            this.calls.decrementAndGet();
        }
    }

    public Integer getCalls() {
        return this.calls.get();
    }

    private class Monitor {
        Class<?> clazz;
        Method method;
        Object instance;
        Class<? extends Annotation> annotation;

        private Monitor() {
        }
    }
}

