/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.classloader.RunAsClassLoader;
import forklift.connectors.ConnectorException;
import forklift.connectors.ForkliftMessage;
import forklift.consumer.Consumer;
import forklift.consumer.LifeCycleMonitors;
import forklift.consumer.ProcessStep;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MessageRunnable.class);
    private static final String RESPONSE = "@ResponseUri";
    private final Consumer consumer;
    private ForkliftMessage msg;
    private ClassLoader classLoader;
    private Object handler;
    private List<Method> onMessage;
    private List<Method> onValidate;
    private List<Method> onResponse;
    private Map<ProcessStep, List<Method>> onProcessStep;
    private List<String> errors;
    private List<Closeable> closeMe;
    private boolean warnOnly = false;
    private LifeCycleMonitors lifeCycle;

    MessageRunnable(Consumer consumer, ForkliftMessage msg, ClassLoader classLoader, Object handler, List<Method> onMessage, List<Method> onValidate, List<Method> onResponse, Map<ProcessStep, List<Method>> onProcessStep, List<Closeable> closeMe) {
        this.consumer = consumer;
        this.msg = msg;
        this.classLoader = classLoader;
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.handler = handler;
        this.onMessage = onMessage;
        this.onValidate = onValidate;
        this.onResponse = onResponse;
        this.onProcessStep = onProcessStep;
        this.errors = new ArrayList<String>();
        this.closeMe = closeMe;
        this.lifeCycle = consumer.getForklift().getLifeCycle();
        this.lifeCycle.call(ProcessStep.Pending, this);
    }

    @Override
    public void run() {
        RunAsClassLoader.run(this.classLoader, () -> {
            boolean acknowledged = false;
            try {
                acknowledged = this.msg.acknowledge();
            }
            catch (ConnectorException e2) {
                log.error("Error while acking message.", (Throwable)e2);
                acknowledged = false;
            }
            if (!acknowledged) {
                this.close();
                return;
            }
            this.runHooks(ProcessStep.Validating);
            this.lifeCycle.call(ProcessStep.Validating, this);
            for (Method m2 : this.onValidate) {
                if (m2.getReturnType() == List.class) {
                    this.addError(this.runLoggingErrors(() -> (List)m2.invoke(this.handler, new Object[0])));
                    continue;
                }
                if (m2.getReturnType() == Boolean.TYPE) {
                    boolean valid = this.runLoggingErrors(() -> (boolean)((Boolean)m2.invoke(this.handler, new Object[0])));
                    if (valid) continue;
                    this.addError("Validator " + m2.getName() + " returned false");
                    continue;
                }
                this.addError("onValidate method " + m2.getName() + " has wrong return type " + m2.getReturnType());
            }
            if (this.errors.size() > 0) {
                this.runHooks(ProcessStep.Invalid);
                this.lifeCycle.call(ProcessStep.Invalid, this);
            } else {
                this.runHooks(ProcessStep.Processing);
                this.lifeCycle.call(ProcessStep.Processing, this);
                for (Method m2 : this.onMessage) {
                    this.runLoggingErrors(() -> m2.invoke(this.handler, new Object[0]));
                }
                if (this.errors.size() > 0) {
                    this.runHooks(ProcessStep.Error);
                    this.lifeCycle.call(ProcessStep.Error, this);
                } else {
                    this.runHooks(ProcessStep.Complete);
                    if (this.msg.getProperties() != null && this.msg.getProperties().containsKey(RESPONSE)) {
                        try {
                            URI uri = new URI(this.msg.getProperties().get(RESPONSE).toString());
                            this.onResponse.stream().forEach(m -> this.runLoggingErrors(() -> this.lambda$null$3(m, uri)));
                        }
                        catch (Exception e3) {
                            log.error("Unable to determine response uri from {}", (Object)this.msg.getProperties().get(RESPONSE), (Object)e3);
                        }
                    }
                    this.lifeCycle.call(ProcessStep.Complete, this);
                }
            }
            if (this.warnOnly) {
                this.getErrors().stream().filter(e -> e != null).forEach(e -> log.warn(e));
            } else {
                this.getErrors().stream().filter(e -> e != null).forEach(e -> log.error(e));
            }
            this.close();
        });
    }

    public void addError(List<String> errors) {
        if (errors == null) {
            return;
        }
        this.errors.addAll(errors);
    }

    public void addError(String e) {
        this.errors.add(e);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ForkliftMessage getMsg() {
        return this.msg;
    }

    public Object getHandler() {
        return this.handler;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setWarnOnly(boolean b) {
        this.warnOnly = b;
    }

    private void close() {
        try {
            for (Closeable c : this.closeMe) {
                c.close();
            }
        }
        catch (IOException e) {
            log.error("Unable to close a resource", (Throwable)e);
        }
    }

    private <T> T runLoggingErrors(DangerousSupplier<T> func) {
        try {
            return func.get();
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            if (e.getCause() == null) {
                this.addError(e.getMessage() + '\n' + sw.toString());
            } else {
                this.addError(e.getCause().getMessage() + '\n' + sw.toString());
            }
            return null;
        }
    }

    private void runHooks(ProcessStep step) {
        for (Method m : this.onProcessStep.get((Object)step)) {
            this.runLoggingErrors(() -> m.invoke(this.handler, new Object[0]));
        }
    }

    public static void main(String[] args) throws Exception {
        URI uri = new URI("queue://duh");
        System.out.println(uri.getScheme());
        System.out.println(uri.getHost());
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Object lambda$null$3(Method m, URI uri) throws Throwable {
        obj = m.invoke(this.handler, new Object[0]);
        respMsg = new ForkliftMessage();
        respMsg.setHeaders(this.msg.getHeaders());
        if (m.getReturnType() == String.class) {
            respMsg.setMsg(obj.toString());
        } else {
            respMsg.setMsg(Consumer.mapper.writeValueAsString(obj));
        }
        var5_5 = uri.getScheme();
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case 107944209: {
                if (!var5_5.equals("queue")) break;
                var6_6 = 0;
                break;
            }
            case 110546223: {
                if (!var5_5.equals("topic")) break;
                var6_6 = 1;
                break;
            }
            case 3213448: {
                if (!var5_5.equals("http")) break;
                var6_6 = 2;
                break;
            }
            case 99617003: {
                if (!var5_5.equals("https")) break;
                var6_6 = 3;
            }
        }
        switch (var6_6) {
            case 0: {
                producer = this.consumer.getForklift().getConnector().getQueueProducer(uri.getHost());
                var8_9 = null;
                System.out.println("Sending: " + respMsg.getMsg());
                producer.send(respMsg);
                if (producer == null) break;
                if (var8_9 == null) ** GOTO lbl42
                try {
                    producer.close();
                }
                catch (Throwable var9_11) {
                    var8_9.addSuppressed(var9_11);
                }
                break;
lbl42:
                // 1 sources

                producer.close();
                break;
                catch (Throwable var9_12) {
                    try {
                        var8_9 = var9_12;
                        throw var9_12;
                    }
                    catch (Throwable var10_15) {
                        if (producer != null) {
                            if (var8_9 != null) {
                                try {
                                    producer.close();
                                }
                                catch (Throwable var11_16) {
                                    var8_9.addSuppressed(var11_16);
                                }
                            } else {
                                producer.close();
                            }
                        }
                        throw var10_15;
                    }
                }
            }
            case 1: {
                producer = this.consumer.getForklift().getConnector().getTopicProducer(uri.getHost());
                var8_10 = null;
                producer.send(respMsg);
                if (producer == null) break;
                if (var8_10 == null) ** GOTO lbl73
                try {
                    producer.close();
                }
                catch (Throwable var9_13) {
                    var8_10.addSuppressed(var9_13);
                }
                break;
lbl73:
                // 1 sources

                producer.close();
                break;
                catch (Throwable var9_14) {
                    try {
                        var8_10 = var9_14;
                        throw var9_14;
                    }
                    catch (Throwable var12_17) {
                        if (producer != null) {
                            if (var8_10 != null) {
                                try {
                                    producer.close();
                                }
                                catch (Throwable var13_18) {
                                    var8_10.addSuppressed(var13_18);
                                }
                            } else {
                                producer.close();
                            }
                        }
                        throw var12_17;
                    }
                }
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                MessageRunnable.log.warn("Unable to find mapping for response uri scheme {}", (Object)uri.getScheme());
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface DangerousSupplier<T> {
        public T get() throws Throwable;
    }
}

