/*
 * Decompiled with CFR 0.152.
 */
package forklift.producers;

import forklift.producers.ForkliftResultResolverI;
import forklift.producers.ResultFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ForkliftResultResolver<T>
implements ForkliftResultResolverI<T> {
    private Map<String, ResultFuture<T>> futures = new ConcurrentHashMap<String, ResultFuture<T>>(new HashMap());

    @Override
    public ResultFuture<T> register(ResultFuture<T> future) {
        if (future == null) {
            return null;
        }
        if (this.futures.containsKey(future.getCorrelationId())) {
            throw new RuntimeException("Duplicate correlation id, unable to register future.");
        }
        this.futures.put(future.getCorrelationId(), future);
        return future;
    }

    @Override
    public void resolve(String correlationId, T t) {
        ResultFuture<T> future = this.futures.remove(correlationId);
        if (future != null) {
            future.complete(t);
        }
    }
}

