/*
 * Decompiled with CFR 0.152.
 */
package forklift.source;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SourceI {
    private static final Logger log = LoggerFactory.getLogger(SourceI.class);
    private Class<?> contextClass;

    public void setContextClass(Class<?> contextClass) {
        this.contextClass = contextClass;
        this.onContextSet();
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    protected void onContextSet() {
    }

    public abstract boolean isLogicalSource();

    public <SOURCE extends SourceI, OUT, EX extends Throwable> SourceIHandler<OUT> apply(Class<SOURCE> sourceType, ExceptionalFunction<SOURCE, OUT, EX> action) throws EX {
        return new SourceIHandler<OUT>(this).apply(sourceType, action);
    }

    public <SOURCE extends SourceI, EX extends Throwable> SourceIHandler<Void> accept(Class<SOURCE> sourceType, ExceptionalConsumer<SOURCE, EX> action) throws EX {
        return this.apply(sourceType, source -> {
            action.accept(source);
            return null;
        });
    }

    public static interface ExceptionalConsumer<I, E extends Throwable> {
        public void accept(I var1) throws E;
    }

    public static interface ExceptionalFunction<I, O, E extends Throwable> {
        public O apply(I var1) throws E;
    }

    public static class SourceIHandler<OUT> {
        private SourceI source;
        private OUT result;
        private boolean handled;

        public SourceIHandler(SourceI source) {
            this.source = source;
        }

        public <SOURCE extends SourceI, EX extends Throwable> SourceIHandler<OUT> apply(Class<SOURCE> sourceType, ExceptionalFunction<SOURCE, OUT, EX> action) throws EX {
            if (!this.handled && sourceType.isInstance(this.source)) {
                try {
                    SourceI specificSource = (SourceI)sourceType.cast(this.source);
                    this.result = action.apply(specificSource);
                    this.handled = true;
                }
                catch (ClassCastException ignored) {
                    log.error("Impossible class cast exception; sound the alarms", (Throwable)ignored);
                }
                catch (Throwable t) {
                    throw t;
                }
            }
            return this;
        }

        public <SOURCE extends SourceI, EX extends Throwable> SourceIHandler<OUT> accept(Class<SOURCE> sourceType, ExceptionalConsumer<SOURCE, EX> action) throws EX {
            return this.apply(sourceType, source -> {
                action.accept(source);
                return null;
            });
        }

        public OUT get() {
            return this.result;
        }

        public OUT getOrDefault(OUT defaultValue) {
            if (!this.handled) {
                return defaultValue;
            }
            return this.result;
        }

        public OUT elseUnsupportedError() {
            if (!this.handled) {
                throw new RuntimeException("SourceType " + this.source.getClass().getSimpleName() + " is not supported");
            }
            return this.result;
        }
    }
}

