/*
 * Decompiled with CFR 0.152.
 */
package forklift.source;

import forklift.source.SourceI;
import forklift.source.SourceType;
import forklift.source.SourceTypeContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.scanners.AbstractScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceUtil {
    private static final Logger log = LoggerFactory.getLogger(SourceUtil.class);

    public static Stream<SourceI> getSources(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).flatMap(annotation -> {
            if (SourceUtil.isSourceAnnotation(annotation)) {
                return Stream.of(annotation);
            }
            if (SourceUtil.isSourceAnnotationContainer(annotation)) {
                return Arrays.stream(SourceUtil.getContainedAnnotations(annotation));
            }
            return Stream.empty();
        }).map(annotation -> {
            SourceI source = SourceUtil.fromSourceAnnotation(annotation);
            source.setContextClass(clazz);
            return source;
        });
    }

    public static List<SourceI> getSourcesAsList(Class<?> clazz) {
        return Collections.unmodifiableList(SourceUtil.getSources(clazz).collect(Collectors.toList()));
    }

    public static <SOURCE extends SourceI> Stream<SOURCE> getSources(Class<?> clazz, Class<SOURCE> sourceType) {
        return SourceUtil.getSources(clazz).filter(source -> sourceType.isInstance(source)).map(source -> {
            try {
                return (SourceI)sourceType.cast(source);
            }
            catch (ClassCastException e) {
                log.error("Impossible class cast exception; sound the alarms", (Throwable)e);
                return null;
            }
        });
    }

    private static Annotation[] getContainedAnnotations(Annotation annotation) {
        try {
            return (Annotation[])annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            return new Annotation[0];
        }
    }

    public static SourceI fromSourceAnnotation(Annotation annotation) {
        if (!SourceUtil.isSourceAnnotation(annotation)) {
            return null;
        }
        try {
            SourceType sourceType = annotation.annotationType().getAnnotation(SourceType.class);
            Class<? extends SourceI> sourceClass = sourceType.value();
            Constructor<? extends SourceI> sourceConstructor = sourceClass.getConstructor(annotation.annotationType());
            return sourceConstructor.newInstance(annotation);
        }
        catch (Exception e) {
            log.error("Could not instantiate source", (Throwable)e);
            return null;
        }
    }

    public static boolean hasSourceAnnotation(Class<?> clazz) {
        return Arrays.asList(clazz.getAnnotations()).stream().anyMatch(annotation -> SourceUtil.isSourceAnnotation(annotation) || SourceUtil.isSourceAnnotationContainer(annotation));
    }

    private static boolean isSourceAnnotation(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(SourceType.class);
    }

    private static boolean isSourceAnnotationContainer(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(SourceTypeContainer.class);
    }

    public static class SourceTypeScanner
    extends AbstractScanner {
        private Set<Class<?>> classesFound = new HashSet();
        private ClassLoader loader;

        public SourceTypeScanner(ClassLoader loader) {
            this.loader = loader;
        }

        public void scan(Object cls) {
            String className = this.getMetadataAdapter().getClassName(cls);
            try {
                Class<?> clazz = this.loader.loadClass(className);
                if (SourceUtil.hasSourceAnnotation(clazz)) {
                    this.classesFound.add(clazz);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.debug("Could not find class while scanning: " + className, e);
            }
        }

        public Set<Class<?>> getSourceAnnotatedTypes() {
            return this.classesFound;
        }
    }
}

