/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.hibernate4.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate4.strategy.NonStrictReadWriteRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.NonStrictReadWriteRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.NonStrictReadWriteRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadOnlyRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadOnlyRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadOnlyRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadWriteRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadWriteRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.ReadWriteRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.hibernate4.strategy.TransactionalRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.TransactionalRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate4.strategy.TransactionalRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisAccessStrategyFactoryImpl
implements RedisAccessStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisAccessStrategyFactoryImpl.class);

    @Override
    public EntityRegionAccessStrategy createEntityRegionAccessStrategy(RedisEntityRegion entityRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (entityRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity regionName=[{}]", (Object)entityRegion.getName());
                }
                return new ReadOnlyRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getSettings());
            }
            case READ_WRITE: {
                return new ReadWriteRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getSettings());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getSettings());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getSettings());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }

    @Override
    public CollectionRegionAccessStrategy createCollectionRegionAccessStrategy(RedisCollectionRegion collectionRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (collectionRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity collectionRegionName=[{}]", (Object)collectionRegion.getName());
                }
                return new ReadOnlyRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getSettings());
            }
            case READ_WRITE: {
                return new ReadWriteRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getSettings());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getSettings());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getSettings());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }

    @Override
    public NaturalIdRegionAccessStrategy createNaturalIdRegionAccessStrategy(RedisNaturalIdRegion naturalIdRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (naturalIdRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity naturalIdRegion=[{}]", (Object)naturalIdRegion.getName());
                }
                return new ReadOnlyRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getSettings());
            }
            case READ_WRITE: {
                return new ReadWriteRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getSettings());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getSettings());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getRedis(), naturalIdRegion.getSettings());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

