/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate4.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRedisEntityRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisEntityRegion>
implements EntityRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalRedisEntityRegionAccessStrategy.class);
    private final RedisClient redis;

    public TransactionalRedisEntityRegionAccessStrategy(RedisEntityRegion region, Settings settings) {
        super(region, settings);
        this.redis = region.getRedis();
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region;
    }

    public Object get(Object key, long txTimestamp) {
        return ((RedisEntityRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisEntityRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) {
        ((RedisEntityRegion)this.region).remove(key);
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) {
        ((RedisEntityRegion)this.region).remove(key);
    }

    public boolean insert(Object key, Object value, Object version) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterInsert(Object key, Object value, Object version) {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    @Override
    public void remove(Object key) {
        ((RedisEntityRegion)this.region).remove(key);
    }

    public RedisClient getRedis() {
        return this.redis;
    }
}

