/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate4.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRedisNaturalIdRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalRedisNaturalIdRegionAccessStrategy.class);
    private final RedisClient redis;

    public TransactionalRedisNaturalIdRegionAccessStrategy(RedisNaturalIdRegion region, RedisClient redis, Settings settings) {
        super(region, settings);
        this.redis = redis;
    }

    public boolean afterInsert(Object key, Object value) {
        return false;
    }

    public boolean afterUpdate(Object key, Object value, SoftLock lock) {
        return false;
    }

    public Object get(Object key, long txTimestamp) {
        return ((RedisNaturalIdRegion)this.region).get(key);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) {
        ((RedisNaturalIdRegion)this.region).remove(key);
        return null;
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisNaturalIdRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public void remove(Object key) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    public void unlockItem(Object key, SoftLock lock) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    public boolean update(Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public RedisClient getRedis() {
        return this.redis;
    }
}

