/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.hibernate52.AbstractRedisRegionFactory;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonRedisRegionFactory
extends AbstractRedisRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(SingletonRedisRegionFactory.class);
    private final Object $lock = new Object[0];
    private final AtomicInteger referenceCount = new AtomicInteger();
    private static final long serialVersionUID = 1858232236910287076L;

    public SingletonRedisRegionFactory(@NonNull Properties props) {
        super(props);
        if (props == null) {
            throw new NullPointerException("props");
        }
        log.info("create SingletonRedisRegionFactory instance.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SessionFactoryOptions options, Properties properties) throws CacheException {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("SingletonRedisRegionFactory is starting... options={}, properties={}", (Object)options, (Object)properties);
            this.options = options;
            try {
                if (this.redis == null) {
                    RedisCacheUtil.loadCacheProperties(properties);
                    this.redis = this.createRedisClient();
                    this.cacheTimestamper = this.createCacheTimestamper(this.redis, SingletonRedisRegionFactory.class.getName());
                }
                if (this.redis != null) {
                    this.referenceCount.incrementAndGet();
                }
                log.info("RedisRegionFactory is started.");
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.redis == null) {
                return;
            }
            if (this.referenceCount.decrementAndGet() == 0) {
                log.debug("RedisRegionFactory is stopping...");
                try {
                    this.redis.shutdown();
                    this.redis = null;
                    this.cacheTimestamper = null;
                    log.info("RedisRegionFactory is stopped.");
                }
                catch (Exception ignored) {
                    log.error("Fail to stop SingletonRedisRegionFactory.", (Throwable)ignored);
                }
            }
        }
    }
}

