/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import java.util.Comparator;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.redis.hibernate52.regions.RedisTransactionalDataRegion;
import org.hibernate.cache.redis.hibernate52.strategy.AbstractRedisAccessStrategy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadWriteRedisAccessStrategy<T extends RedisTransactionalDataRegion>
extends AbstractRedisAccessStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadWriteRedisAccessStrategy.class);
    private final Comparator versionComparator;

    public AbstractReadWriteRedisAccessStrategy(T region, SessionFactoryOptions options) {
        super(region, options);
        this.versionComparator = ((RedisTransactionalDataRegion)region).getCacheDataDescription().getVersionComparator();
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        this.region.put(key, value);
        return true;
    }
}

