/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate52.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate52.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRedisNaturalIdRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalRedisNaturalIdRegionAccessStrategy.class);

    public TransactionalRedisNaturalIdRegionAccessStrategy(RedisNaturalIdRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) {
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) {
        return false;
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) {
        return ((RedisNaturalIdRegion)this.region).get(key);
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SharedSessionContractImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        ((RedisNaturalIdRegion)this.region).remove(key);
        return null;
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisNaturalIdRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public void remove(SharedSessionContractImplementor session, Object key) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }
}

