/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.File;
import java.security.KeyStore;
import org.beigesoft.afactory.IFactoryAppBeans;
import org.eclipse.jetty.security.DataBaseLoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class BootEmbed {
    private IFactoryAppBeans factoryAppBeans;
    private Integer port = 8443;
    private String webAppPath = "webapp";
    private Server server;
    private WebAppContext webAppContext;
    private boolean isStarted = false;
    private String password;
    private File pkcs12File;
    private String httpsAlias;
    private String httpsPassword;
    private String cryptoProviderName = "BC";
    private KeyStore keyStore;
    private Integer ajettyIn;

    public final void createServer() throws Exception {
        try {
            File webappdir = new File(this.getWebAppPath());
            if (!webappdir.exists() || !webappdir.isDirectory()) {
                throw new Exception("Web app directory not found: " + this.getWebAppPath());
            }
            this.server = new Server();
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.pkcs12File.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(this.password);
            sslContextFactory.setKeyStoreProvider(this.cryptoProviderName);
            sslContextFactory.setKeyStoreType("PKCS12");
            if (this.httpsPassword != null) {
                sslContextFactory.setKeyManagerPassword(this.httpsPassword);
            }
            sslContextFactory.setCertAlias(this.httpsAlias);
            HttpConfiguration httpsConf = new HttpConfiguration();
            httpsConf.setSecureScheme("https");
            httpsConf.setSecurePort(this.port);
            httpsConf.setOutputBufferSize(32768);
            httpsConf.addCustomizer(new SecureRequestCustomizer());
            ServerConnector connector = new ServerConnector(this.server, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConf));
            connector.setHost("127.0.0.1");
            connector.setPort(this.port);
            connector.setIdleTimeout(500000L);
            this.server.setConnectors(new Connector[]{connector});
            this.webAppContext = new WebAppContext(webappdir.getAbsolutePath(), "/bsa" + this.port + "/");
            DataBaseLoginService dataBaseLoginService = new DataBaseLoginService("JDBCRealm");
            this.webAppContext.getSecurityHandler().setLoginService(dataBaseLoginService);
            this.webAppContext.setAttribute("JDBCRealm", dataBaseLoginService);
            this.webAppContext.setFactoryAppBeans(this.getFactoryAppBeans());
            this.webAppContext.setDefaultsDescriptor(webappdir.getAbsolutePath() + File.separator + "webdefault.xml");
            this.webAppContext.setAttribute("ajettyKeystore", this.keyStore);
            this.webAppContext.setAttribute("ajettyIn", this.ajettyIn);
            this.webAppContext.setAttribute("ksPassword", this.password);
            this.server.setHandler(this.webAppContext);
        }
        catch (Exception e) {
            this.server = null;
            this.webAppContext = null;
            throw e;
        }
    }

    public final void startServer() throws Exception {
        try {
            if (this.server == null) {
                this.createServer();
            }
            this.server.start();
            this.isStarted = true;
        }
        catch (Exception e) {
            this.server = null;
            this.webAppContext = null;
        }
    }

    public final void stopServer() throws Exception {
        try {
            this.server.stop();
            this.server.destroy();
        }
        finally {
            this.server = null;
            this.webAppContext = null;
            this.isStarted = false;
        }
    }

    public final Integer getPort() {
        return this.port;
    }

    public final void setPort(Integer pPort) {
        this.port = pPort;
    }

    public final Server getServer() {
        return this.server;
    }

    public final boolean getIsStarted() {
        return this.isStarted;
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getWebAppPath() {
        return this.webAppPath;
    }

    public final void setWebAppPath(String pWebAppPath) {
        this.webAppPath = pWebAppPath;
    }

    public final WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String pPassword) {
        this.password = pPassword;
    }

    public final File getPkcs12File() {
        return this.pkcs12File;
    }

    public final void setPkcs12File(File pPkcs12File) {
        this.pkcs12File = pPkcs12File;
    }

    public final String getHttpsAlias() {
        return this.httpsAlias;
    }

    public final void setHttpsAlias(String pHttpsAlias) {
        this.httpsAlias = pHttpsAlias;
    }

    public final String getHttpsPassword() {
        return this.httpsPassword;
    }

    public final void setHttpsPassword(String pHttpsPassword) {
        this.httpsPassword = pHttpsPassword;
    }

    public final String getCryptoProviderName() {
        return this.cryptoProviderName;
    }

    public final void setCryptoProviderName(String pCryptoProviderName) {
        this.cryptoProviderName = pCryptoProviderName;
    }

    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    public final void setKeyStore(KeyStore pKeyStore) {
        this.keyStore = pKeyStore;
    }

    public final Integer getAjettyIn() {
        return this.ajettyIn;
    }

    public final void setAjettyIn(Integer pAjettyIn) {
        this.ajettyIn = pAjettyIn;
    }
}

