/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.File;
import org.beigesoft.afactory.IFactoryAppBeans;
import org.beigesoft.ajetty.FctApp;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;

public class BootStrap {
    private IFactoryAppBeans factoryAppBeans;
    private Integer port = 8080;
    private String jettyBase = "";
    private Server server;
    private boolean isStarted = false;
    private DeploymentManager deploymentManager;
    private ServerConnector connector;

    public final void createServer() throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.connector.setPort(this.port);
        this.connector.setHost("127.0.0.1");
        this.server.setConnectors(new Connector[]{this.connector});
        HandlerCollection handlers = new HandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{contextHandlerCollection, defaultHandler});
        this.server.setHandler(handlers);
        this.deploymentManager = new DeploymentManager();
        this.deploymentManager.setContexts(contextHandlerCollection);
        WebAppProvider webAppProvider = new WebAppProvider();
        webAppProvider.setFactoryAppBeans(this.factoryAppBeans);
        webAppProvider.setMonitoredDirName(this.jettyBase + File.separator + "webapps");
        webAppProvider.setDefaultsDescriptor(this.jettyBase + File.separator + "webdefault.xml");
        webAppProvider.setExtractWars(false);
        PropertiesConfigurationManager confManager = new PropertiesConfigurationManager();
        webAppProvider.setConfigurationManager(confManager);
        this.deploymentManager.addAppProvider(webAppProvider);
        this.server.addBean(this.deploymentManager);
    }

    public final void startServer() throws Exception {
        this.connector.setPort(this.port);
        this.server.start();
        this.isStarted = true;
    }

    public final void stopServer() throws Exception {
        this.server.stop();
        this.isStarted = false;
    }

    public static final void main(String[] pArgs) {
        try {
            BootStrap bootStrap = new BootStrap();
            for (String arg : pArgs) {
                if (arg.contains("port=")) {
                    String strPort = arg.replace("port=", "").trim();
                    bootStrap.setPort(Integer.parseInt(strPort));
                    continue;
                }
                if (!arg.contains("jetty:base=")) continue;
                bootStrap.setJettyBase(arg.replace("jetty:base=", "").trim());
            }
            bootStrap.setFactoryAppBeans(new FctApp());
            bootStrap.createServer();
            bootStrap.startServer();
            bootStrap.getServer().join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final Integer getPort() {
        return this.port;
    }

    public final void setPort(Integer pPort) {
        this.port = pPort;
    }

    public final String getJettyBase() {
        return this.jettyBase;
    }

    public final void setJettyBase(String pJettyBase) {
        this.jettyBase = pJettyBase;
    }

    public final Server getServer() {
        return this.server;
    }

    public final ServerConnector getConnector() {
        return this.connector;
    }

    public final boolean getIsStarted() {
        return this.isStarted;
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }
}

