/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import org.beigesoft.ajetty.crypto.ICryptoService;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;

public class CryptoService
implements ICryptoService {
    private ResourceBundle messages;

    public CryptoService() {
        try {
            this.messages = ResourceBundle.getBundle("MessagesCrypto");
        }
        catch (Exception e) {
            try {
                Locale locale = new Locale("en", "US");
                this.messages = ResourceBundle.getBundle("MessagesCrypto", locale);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public final String isPasswordStrong(char[] pPassword) {
        if (pPassword == null || pPassword.length < 15) {
            return this.getMsg("Password15");
        }
        String passw = new String(pPassword).toLowerCase();
        if (passw.contains("qwert") || passw.contains("qwaszx") || passw.contains("qweasd") || passw.contains("qazwsx") || passw.contains("wsxedc") || passw.contains("wqsaxz") || passw.contains("ewqdsa") || passw.contains("zaqxsw") || passw.contains("xswzaq") || passw.contains("qscwdv") || passw.contains("csqvdw") || passw.contains("zaxqsc") || passw.contains("qscax") || passw.contains("csqxa") || passw.contains("trewq") || passw.contains("asdfg") || passw.contains("zxcvb") || passw.contains("bvcxz") || passw.contains("gfdsa")) {
            return this.getMsg("noQwerty");
        }
        if (passw.contains("raccooneatstone") || passw.contains("nraccooteaeston")) {
            return this.getMsg("noDemoPassw");
        }
        if (passw.contains("2345") || passw.contains("admin") || passw.contains("user") || passw.contains("5432") || passw.contains("5678") || passw.contains("9876") || passw.contains("password")) {
            return this.getMsg("noAdmin12345");
        }
        HashSet<Character> chars = new HashSet<Character>();
        ArrayList<Character> digits = new ArrayList<Character>();
        ArrayList<Character> letters = new ArrayList<Character>();
        for (char ch : pPassword) {
            if (!Character.isLetterOrDigit(ch)) {
                return this.getMsg("letterOrDig");
            }
            if (Character.isDigit(ch)) {
                digits.add(Character.valueOf(ch));
            } else {
                letters.add(Character.valueOf(ch));
            }
            chars.add(Character.valueOf(ch));
        }
        double allLn = pPassword.length;
        double lettersLn = letters.size();
        double distinctLn = chars.size();
        if (lettersLn / allLn < 0.49999999999) {
            return this.getMsg("lettersAtLeast50pr");
        }
        if (distinctLn / allLn < 0.59999999999) {
            return this.getMsg("distinct60pr");
        }
        if (digits.size() < 3) {
            return this.getMsg("atLeast3digits");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createKeyStoreWithCredentials(String pFilePath, int pAjettyIn, char[] pPassw) throws Exception {
        File pks12File = pFilePath == null ? new File("ajettykeystore." + pAjettyIn) : new File(pFilePath + File.separator + "ajettykeystore." + pAjettyIn);
        if (pks12File.exists()) {
            throw new Exception("File already exist - " + pks12File.getPath());
        }
        KeyPairGenerator kpGenRsa = KeyPairGenerator.getInstance("RSA", "BC");
        kpGenRsa.initialize(2048, new SecureRandom());
        KeyPair kpHttps = kpGenRsa.generateKeyPair();
        kpGenRsa.initialize(2048, new SecureRandom());
        KeyPair kpFileExch = kpGenRsa.generateKeyPair();
        Calendar cal = Calendar.getInstance();
        Date start = cal.getTime();
        cal.add(1, 10);
        Date end = cal.getTime();
        kpGenRsa.initialize(2048, new SecureRandom());
        KeyPair kpCa = kpGenRsa.generateKeyPair();
        String x500dn = "CN=A-Jetty" + pAjettyIn + " CA, OU=A-Jetty" + pAjettyIn + " CA, O=A-Jetty" + pAjettyIn + " CA, C=RU";
        X509Certificate caCert = this.buildCaCertSelfSign(kpCa, x500dn, start, end);
        x500dn = "CN=localhost, OU=A-Jetty" + pAjettyIn + " HTTPS, O=A-Jetty" + pAjettyIn + " HTTPS, C=RU";
        X509Certificate httpsCert = this.buildLocalhostHttpsCert(kpHttps.getPublic(), kpCa.getPrivate(), caCert, 2, x500dn, start, end);
        x500dn = "CN=A-Jetty" + pAjettyIn + " File Exchanger, OU=A-Jetty" + pAjettyIn + " File Exchanger, O=A-Jetty" + pAjettyIn + " File Exchanger, C=RU";
        X509Certificate fileExchCert = this.buildEndEntityCert(kpFileExch.getPublic(), kpCa.getPrivate(), caCert, 3, x500dn, start, end);
        JcePKCSPBEOutputEncryptorBuilder jcePcEb = new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes256_CBC);
        jcePcEb.setProvider("BC");
        OutputEncryptor encOut = jcePcEb.build(pPassw);
        JcaPKCS12SafeBagBuilder caCrtBagBld = new JcaPKCS12SafeBagBuilder(caCert);
        caCrtBagBld.addBagAttribute(PKCS12SafeBag.friendlyNameAttribute, (ASN1Encodable)new DERBMPString("AJettyCa" + pAjettyIn));
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        JcaPKCS12SafeBagBuilder httpsCrBgBr = new JcaPKCS12SafeBagBuilder(httpsCert);
        httpsCrBgBr.addBagAttribute(PKCS12SafeBag.friendlyNameAttribute, (ASN1Encodable)new DERBMPString("AJettyHttps" + pAjettyIn));
        SubjectKeyIdentifier skiHttps = extUtils.createSubjectKeyIdentifier(httpsCert.getPublicKey());
        httpsCrBgBr.addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)skiHttps);
        JcaPKCS12SafeBagBuilder httpsKbb = new JcaPKCS12SafeBagBuilder(kpHttps.getPrivate(), encOut);
        httpsKbb.addBagAttribute(PKCS12SafeBag.friendlyNameAttribute, (ASN1Encodable)new DERBMPString("AJettyHttps" + pAjettyIn));
        httpsKbb.addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)skiHttps);
        JcaPKCS12SafeBagBuilder fileExchCrBgBr = new JcaPKCS12SafeBagBuilder(fileExchCert);
        fileExchCrBgBr.addBagAttribute(PKCS12SafeBag.friendlyNameAttribute, (ASN1Encodable)new DERBMPString("AJettyFileExch" + pAjettyIn));
        SubjectKeyIdentifier skiFileExch = extUtils.createSubjectKeyIdentifier(fileExchCert.getPublicKey());
        fileExchCrBgBr.addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)skiFileExch);
        JcaPKCS12SafeBagBuilder fileExchKbb = new JcaPKCS12SafeBagBuilder(kpFileExch.getPrivate(), encOut);
        fileExchKbb.addBagAttribute(PKCS12SafeBag.friendlyNameAttribute, (ASN1Encodable)new DERBMPString("AJettyFileExch" + pAjettyIn));
        fileExchKbb.addBagAttribute(PKCS12SafeBag.localKeyIdAttribute, (ASN1Encodable)skiFileExch);
        PKCS12PfxPduBuilder builder = new PKCS12PfxPduBuilder();
        builder.addData(httpsKbb.build());
        builder.addData(fileExchKbb.build());
        builder.addEncryptedData(new JcePKCSPBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC).setProvider("BC").build(pPassw), new PKCS12SafeBag[]{httpsCrBgBr.build(), fileExchCrBgBr.build(), caCrtBagBld.build()});
        JcePKCS12MacCalculatorBuilder jmcb = new JcePKCS12MacCalculatorBuilder();
        jmcb.setProvider("BC");
        PKCS12PfxPdu pfx = builder.build((PKCS12MacCalculatorBuilder)jmcb, pPassw);
        try (FileOutputStream pfxOut = null;){
            pfxOut = new FileOutputStream(pks12File);
            pfxOut.write(pfx.getEncoded("DL"));
            pfxOut.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] calculateSha1(File pFile) throws Exception {
        BufferedInputStream bis = null;
        SHA1Digest sha1 = new SHA1Digest();
        try {
            bis = new BufferedInputStream(new FileInputStream(pFile));
            byte[] buffer = new byte[1024];
            while (bis.read(buffer) >= 0) {
                sha1.update(buffer, 0, buffer.length);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        byte[] digest = new byte[sha1.getDigestSize()];
        sha1.doFinal(digest, 0);
        return digest;
    }

    @Override
    public final void init() throws Exception {
        Security.removeProvider(this.getProviderName());
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public final String getProviderName() {
        return "BC";
    }

    public final String getMsg(String pKey) {
        try {
            return this.messages.getString(pKey);
        }
        catch (Exception e) {
            return "[" + pKey + "]";
        }
    }

    public final X509Certificate buildRootCert(KeyPair pKpRoot, String pX500dn, Date pStart, Date pEnd) throws Exception {
        JcaX509v1CertificateBuilder certBldr = new JcaX509v1CertificateBuilder(new X500Name(pX500dn), BigInteger.valueOf(1L), pStart, pEnd, new X500Name(pX500dn), pKpRoot.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(pKpRoot.getPrivate());
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBldr.build(signer));
    }

    public final X509Certificate buildCaCert(PublicKey pCaPk, PrivateKey pRootSk, X509Certificate pRootCert, String pX500dn, Date pStart, Date pEnd) throws Exception {
        JcaX509v3CertificateBuilder certBldr = new JcaX509v3CertificateBuilder(pRootCert.getSubjectX500Principal(), BigInteger.valueOf(2L), pStart, pEnd, new X500Principal(pX500dn), pCaPk);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        certBldr.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(pRootCert)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pCaPk)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(pRootSk);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBldr.build(signer));
    }

    public final X509Certificate buildCaCertSelfSign(KeyPair pKpCa, String pX500dn, Date pStart, Date pEnd) throws Exception {
        JcaX509v3CertificateBuilder certBldr = new JcaX509v3CertificateBuilder(new X500Principal(pX500dn), BigInteger.valueOf(1L), pStart, pEnd, new X500Principal(pX500dn), pKpCa.getPublic());
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        certBldr.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pKpCa.getPublic()));
        certBldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        certBldr.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(pKpCa.getPrivate());
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBldr.build(signer));
    }

    public final X509Certificate buildEndEntityCert(PublicKey pEntityPk, PrivateKey pCaSk, X509Certificate pCaCert, int pSn, String pX500dn, Date pStart, Date pEnd) throws Exception {
        JcaX509v3CertificateBuilder certBldr = new JcaX509v3CertificateBuilder(pCaCert.getSubjectX500Principal(), BigInteger.valueOf(pSn), pStart, pEnd, new X500Principal(pX500dn), pEntityPk);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        certBldr.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(pCaCert)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pEntityPk)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(pCaSk);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBldr.build(signer));
    }

    public final X509Certificate buildLocalhostHttpsCert(PublicKey pEntityPk, PrivateKey pCaSk, X509Certificate pCaCert, int pSn, String pX500dn, Date pStart, Date pEnd) throws Exception {
        JcaX509v3CertificateBuilder certBldr = new JcaX509v3CertificateBuilder(pCaCert.getSubjectX500Principal(), BigInteger.valueOf(pSn), pStart, pEnd, new X500Principal(pX500dn), pEntityPk);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        certBldr.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(pCaCert));
        certBldr.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pEntityPk));
        certBldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        certBldr.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        GeneralName dns = new GeneralName(2, "localhost");
        GeneralName ip = new GeneralName(7, "127.0.0.1");
        GeneralNames dnsIp = new GeneralNames(new GeneralName[]{dns, ip});
        certBldr.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)dnsIp);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(pCaSk);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBldr.build(signer));
    }

    public final ResourceBundle getMessages() {
        return this.messages;
    }

    public final void setMessages(ResourceBundle pMessages) {
        this.messages = pMessages;
    }
}

