/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.beigesoft.afactory.IFactoryAppBeans;
import org.beigesoft.afactory.IFactoryParam;
import org.beigesoft.lang.IUrlClassLoader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class WebAppClassLoader
extends ClassLoader {
    private final IUrlClassLoader delegate;
    private final IFactoryAppBeans factoryAppBeans;
    private static final Logger LOG = Log.getLogger(WebAppClassLoader.class);
    private final Context _context;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());

    public WebAppClassLoader(Context context, IFactoryAppBeans pFactoryAppBeans) throws Exception {
        this(null, context, pFactoryAppBeans);
    }

    public WebAppClassLoader(ClassLoader parent, Context context, IFactoryAppBeans pFactoryAppBeans) throws Exception {
        this.factoryAppBeans = pFactoryAppBeans;
        IFactoryParam factoryUrlClassLoader = (IFactoryParam)this.factoryAppBeans.lazyGet("IFactoryParam<IUrlClassLoader, WebAppClassLoader.Context>");
        this.delegate = (IUrlClassLoader)factoryUrlClassLoader.create(context);
        this._context = context;
        this._extensions.add(".jar");
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) throws IOException {
        if (resource instanceof ResourceCollection) {
            for (Resource r : ((ResourceCollection)resource).getResources()) {
                this.addClassPath(r);
            }
        } else {
            this.addClassPath(resource.toString());
        }
    }

    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = this._context.newResource(tokenizer.nextToken().trim());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path resource=" + resource, new Object[0]);
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection) {
                this.addClassPath(resource);
                continue;
            }
            File file = resource.getFile();
            if (file != null) {
                URL url = resource.getURL();
                this.delegate.addUrl(url);
                continue;
            }
            if (resource.isDirectory()) {
                this.delegate.addUrl(resource.getURL());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check file exists and is not nested jar: " + resource, new Object[0]);
            }
            throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + resource);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase(Locale.ENGLISH);
                    if (!this.isFileSupported(fnlc)) continue;
                    String jar = fn.toString();
                    jar = StringUtil.replace(jar, ",", "%2C");
                    jar = StringUtil.replace(jar, ";", "%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", ex);
                }
            }
        }
    }

    public String toString() {
        return "WebAppClassLoader=" + this._name + "@" + Long.toHexString(this.hashCode());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.delegate.findClass(name);
    }

    public static interface Context {
        public Resource newResource(String var1) throws IOException;

        public PermissionCollection getPermissions();

        public boolean isSystemClass(String var1);

        public boolean isServerClass(String var1);

        public boolean isParentLoaderPriority();

        public String getExtraClasspath();
    }
}

