/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.beigesoft.lang.IUrlClassLoader;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppClassLoader;

public class WebAppClassLoaderStd
extends URLClassLoader
implements IUrlClassLoader {
    private static final Logger LOG = Log.getLogger(WebAppClassLoaderStd.class);
    private final ClassLoader _parent;
    private final WebAppClassLoader.Context _context;
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private String _name = String.valueOf(this.hashCode());

    public WebAppClassLoaderStd(WebAppClassLoader.Context context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoaderStd(ClassLoader parent, WebAppClassLoader.Context context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoaderStd.class.getClassLoader() != null ? WebAppClassLoaderStd.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._context = context;
        this._parent = this.getParent();
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
    }

    @Override
    public void addUrl(URL pUrl) {
        this.addURL(pUrl);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        List<URL> from_parent = this.toList(server_class ? null : this._parent.getResources(name));
        List<URL> from_webapp = this.toList((Enumeration<URL>)(system_class && !from_parent.isEmpty() ? null : this.findResources(name)));
        if (this._context.isParentLoaderPriority()) {
            from_parent.addAll(from_webapp);
            return Collections.enumeration(from_parent);
        }
        from_webapp.addAll(from_parent);
        return Collections.enumeration(from_webapp);
    }

    private List<URL> toList(Enumeration<URL> e) {
        if (e == null) {
            return new ArrayList<URL>();
        }
        return Collections.list(e);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        String tmp = name;
        if (tmp != null && tmp.endsWith(".class")) {
            tmp = tmp.substring(0, tmp.length() - 6);
        }
        boolean system_class = this._context.isSystemClass(tmp);
        boolean server_class = this._context.isServerClass(tmp);
        if (system_class && server_class) {
            return null;
        }
        if (this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HACK leading / off " + name, new Object[0]);
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null && !tried_parent && !server_class && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug("getResource(" + name + ")=" + url, new Object[0]);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        if (system_class && server_class) {
            return null;
        }
        if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("loaded " + c, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent && !server_class) {
            c = this._parent.loadClass(name);
        }
        if (c == null && ex != null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("loaded {} from {}", c, c == null ? null : c.getClassLoader());
        }
        return c;
    }

    public void addClassFileTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeClassFileTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this._transformers.isEmpty()) {
            clazz = super.findClass(name);
        } else {
            String path = name.replace('.', '/').concat(".class");
            URL url = this.getResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            InputStream content = null;
            try {
                content = url.openStream();
                byte[] bytes = IO.readBytes(content);
                for (ClassFileTransformer transformer : this._transformers) {
                    byte[] tmp = transformer.transform(this, name, null, null, bytes);
                    if (tmp == null) continue;
                    bytes = tmp;
                }
                clazz = this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
            catch (IllegalClassFormatException e) {
                throw new ClassNotFoundException(name, e);
            }
            finally {
                if (content != null) {
                    try {
                        content.close();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
            }
        }
        return clazz;
    }

    public String toString() {
        return "WebAppClassLoader=" + this._name + "@" + Long.toHexString(this.hashCode());
    }
}

