/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngImageType;
import com.googlecode.pngtastic.core.PngProcessor;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngInterlaceHandler;
import com.googlecode.pngtastic.core.processing.PngtasticInterlaceHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class PngReader
extends PngProcessor {
    private final PngInterlaceHandler pngInterlaceHandler;

    public PngReader() {
        this("NONE");
    }

    public PngReader(String logLevel) {
        super(logLevel);
        this.pngInterlaceHandler = new PngtasticInterlaceHandler(this.log, this.pngFilterHandler);
    }

    public static byte[] readRGBA8(byte[] image) {
        try {
            return new PngReader().readRGBA8(new PngImage(image));
        }
        catch (IOException e) {
            throw new PngException(e);
        }
    }

    public byte[] readRGBA8(PngImage image) throws IOException {
        this.log.debug("=== READING ===", new Object[0]);
        if (image.getInterlace() == 1 && image.getSampleBitCount() < 8) {
            throw new PngException("not supported");
        }
        Iterator<PngChunk> itChunks = image.getChunks().iterator();
        PngChunk chunk = this.processHeadChunks(null, false, itChunks);
        PngByteArrayOutputStream inflatedImageData = this.getInflatedImageData(chunk, itChunks);
        long width = image.getWidth();
        long height = image.getHeight();
        int scanlineLength = (int)Math.ceil((float)(width * (long)image.getSampleBitCount()) / 8.0f) + 1;
        List<byte[]> originalScanlines = image.getInterlace() == 1 ? this.pngInterlaceHandler.deInterlace((int)width, (int)height, image.getSampleBitCount(), inflatedImageData) : this.getScanlines(inflatedImageData, image.getSampleBitCount(), scanlineLength, height);
        byte[] rgba = this.getRGBA8(image, originalScanlines);
        return rgba;
    }

    private byte[] getRGBA8(PngImage original, List<byte[]> rows) throws IOException {
        PngImageType imageType = PngImageType.forColorType(original.getColorType());
        int sampleSize = original.getSampleBitCount();
        int perRow = (rows.get(0).length - 1) * 8 / sampleSize;
        byte[] result = new byte[perRow * 4 * rows.size()];
        int y = 0;
        for (byte[] row : rows) {
            int sampleCount = (row.length - 1) * 8 / sampleSize;
            byte[] normalized = this.normalize(row, original.getBitDepth());
            ByteArrayInputStream ins = new ByteArrayInputStream(normalized);
            DataInputStream dis = new DataInputStream(ins);
            block8: for (int x = 0; x < sampleCount; ++x) {
                switch (imageType) {
                    case INDEXED_COLOR: {
                        int offset = dis.readUnsignedByte() * 3;
                        short r = original.getPalette().getUnsignedByte(offset);
                        short g = original.getPalette().getUnsignedByte(offset + 1);
                        short b = original.getPalette().getUnsignedByte(offset + 2);
                        int index = (y * perRow + x) * 4;
                        result[index] = (byte)r;
                        result[index + 1] = (byte)g;
                        result[index + 2] = (byte)b;
                        result[index + 3] = -1;
                        continue block8;
                    }
                    case GREYSCALE: {
                        int p;
                        if (original.getBitDepth() == 16) {
                            p = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                            int v = Integer.divideUnsigned(p, 65535) + (Integer.remainderUnsigned(p, 65535) > Short.MAX_VALUE ? 1 : 0);
                            int index = (y * perRow + x) * 4;
                            result[index] = (byte)v;
                            result[index + 1] = (byte)v;
                            result[index + 2] = (byte)v;
                            result[index + 3] = -1;
                            continue block8;
                        }
                        p = dis.readUnsignedByte() * 255;
                        int max = (int)(Math.pow(2.0, original.getBitDepth()) - 1.0);
                        int v = Integer.divideUnsigned(p, max) + (Integer.remainderUnsigned(p, max) > max / 2 ? 1 : 0);
                        int index2 = (y * perRow + x) * 4;
                        result[index2] = (byte)v;
                        result[index2 + 1] = (byte)v;
                        result[index2 + 2] = (byte)v;
                        result[index2 + 3] = -1;
                        continue block8;
                    }
                    case GREYSCALE_ALPHA: {
                        int a;
                        int p;
                        int index;
                        if (original.getBitDepth() == 8) {
                            p = dis.readUnsignedByte() * 255;
                            a = dis.readUnsignedByte() * 255;
                            int max = (int)(Math.pow(2.0, original.getBitDepth()) - 1.0);
                            int v = Integer.divideUnsigned(p, max) + (Integer.remainderUnsigned(p, max) > max / 2 ? 1 : 0);
                            index = (y * perRow + x) * 4;
                            result[index] = (byte)v;
                            result[index + 1] = (byte)v;
                            result[index + 2] = (byte)v;
                            result[index + 3] = (byte)(Integer.divideUnsigned(a, max) + (Integer.remainderUnsigned(a, max) > max / 2 ? 1 : 0));
                            continue block8;
                        }
                        if (original.getBitDepth() != 16) continue block8;
                        p = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                        a = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                        int v = Integer.divideUnsigned(p, 65535) + (Integer.remainderUnsigned(p, 65535) > Short.MAX_VALUE ? 1 : 0);
                        int index2 = (y * perRow + x) * 4;
                        result[index2] = (byte)v;
                        result[index2 + 1] = (byte)v;
                        result[index2 + 2] = (byte)v;
                        result[index2 + 3] = (byte)(Integer.divideUnsigned(a, 65535) + (Integer.remainderUnsigned(a, 65535) > Short.MAX_VALUE ? 1 : 0));
                        continue block8;
                    }
                    case TRUECOLOR: {
                        int b;
                        int g;
                        int r;
                        int index2;
                        if (original.getBitDepth() == 8) {
                            r = dis.readUnsignedByte();
                            g = dis.readUnsignedByte();
                            b = dis.readUnsignedByte();
                            index2 = (y * perRow + x) * 4;
                            result[index2] = (byte)r;
                            result[index2 + 1] = (byte)g;
                            result[index2 + 2] = (byte)b;
                            result[index2 + 3] = -1;
                            continue block8;
                        }
                        if (original.getBitDepth() != 16) continue block8;
                        r = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                        g = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                        b = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                        index2 = (y * perRow + x) * 4;
                        result[index2] = (byte)(Integer.divideUnsigned(r, 65535) + (Integer.remainderUnsigned(r, 65535) > Short.MAX_VALUE ? 1 : 0));
                        result[index2 + 1] = (byte)(Integer.divideUnsigned(g, 65535) + (Integer.remainderUnsigned(g, 65535) > Short.MAX_VALUE ? 1 : 0));
                        result[index2 + 2] = (byte)(Integer.divideUnsigned(b, 65535) + (Integer.remainderUnsigned(b, 65535) > Short.MAX_VALUE ? 1 : 0));
                        result[index2 + 3] = -1;
                        continue block8;
                    }
                    case TRUECOLOR_ALPHA: {
                        int a;
                        int b;
                        int g;
                        int r;
                        int index;
                        if (original.getBitDepth() == 16) {
                            r = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                            g = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                            b = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                            a = ((dis.readUnsignedByte() << 8) + dis.readUnsignedByte()) * 255;
                            index = (y * perRow + x) * 4;
                            result[index] = (byte)(Integer.divideUnsigned(r, 65535) + (Integer.remainderUnsigned(r, 65535) > Short.MAX_VALUE ? 1 : 0));
                            result[index + 1] = (byte)(Integer.divideUnsigned(g, 65535) + (Integer.remainderUnsigned(g, 65535) > Short.MAX_VALUE ? 1 : 0));
                            result[index + 2] = (byte)(Integer.divideUnsigned(b, 65535) + (Integer.remainderUnsigned(b, 65535) > Short.MAX_VALUE ? 1 : 0));
                            result[index + 3] = (byte)(Integer.divideUnsigned(a, 65535) + (Integer.remainderUnsigned(a, 65535) > Short.MAX_VALUE ? 1 : 0));
                            continue block8;
                        }
                        r = dis.readUnsignedByte();
                        g = dis.readUnsignedByte();
                        b = dis.readUnsignedByte();
                        a = dis.readUnsignedByte();
                        index = (y * perRow + x) * 4;
                        result[index] = (byte)r;
                        result[index + 1] = (byte)g;
                        result[index + 2] = (byte)b;
                        result[index + 3] = (byte)a;
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            ++y;
        }
        return result;
    }

    private byte[] normalize(byte[] imageData, int bitDepth) {
        byte[] scaled;
        int length = imageData.length - 1;
        switch (bitDepth) {
            default: {
                throw new PngException("unrecognised depth");
            }
            case 8: 
            case 16: {
                byte[] scaled2 = new byte[length];
                System.arraycopy(imageData, 1, scaled2, 0, length);
                return scaled2;
            }
            case 4: {
                scaled = new byte[length * 2];
                break;
            }
            case 2: {
                scaled = new byte[length * 4];
                break;
            }
            case 1: {
                scaled = new byte[length * 8];
            }
        }
        block11: for (int i = 0; i < length; ++i) {
            byte b = imageData[i + 1];
            switch (bitDepth) {
                case 4: {
                    byte byte1;
                    byte byte2 = (byte)(b & 0xF);
                    scaled[i * 2] = byte1 = (byte)(b >> 4);
                    scaled[i * 2 + 1] = byte2;
                    continue block11;
                }
                case 2: {
                    byte byte1;
                    byte byte4 = (byte)(b & 3);
                    byte byte3 = (byte)(b >> 2 & 3);
                    byte byte2 = (byte)(b >> 4 & 3);
                    scaled[i * 4] = byte1 = (byte)(b >> 6 & 3);
                    scaled[i * 4 + 1] = byte2;
                    scaled[i * 4 + 2] = byte3;
                    scaled[i * 4 + 3] = byte4;
                    continue block11;
                }
                case 1: {
                    byte byte1;
                    byte byte8 = (byte)(b & 1);
                    byte byte7 = (byte)(b >> 1 & 1);
                    byte byte6 = (byte)(b >> 2 & 1);
                    byte byte5 = (byte)(b >> 3 & 1);
                    byte byte4 = (byte)(b >> 4 & 1);
                    byte byte3 = (byte)(b >> 5 & 1);
                    byte byte2 = (byte)(b >> 6 & 1);
                    scaled[i * 8] = byte1 = (byte)(b >> 7 & 1);
                    scaled[i * 8 + 1] = byte2;
                    scaled[i * 8 + 2] = byte3;
                    scaled[i * 8 + 3] = byte4;
                    scaled[i * 8 + 4] = byte5;
                    scaled[i * 8 + 5] = byte6;
                    scaled[i * 8 + 6] = byte7;
                    scaled[i * 8 + 7] = byte8;
                }
            }
        }
        return scaled;
    }
}

