/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngFilterHandler;
import com.googlecode.pngtastic.core.processing.PngInterlaceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PngtasticInterlaceHandler
implements PngInterlaceHandler {
    private final Logger log;
    private PngFilterHandler pngFilterHandler;
    private static final int[] interlaceRowOffset = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] interlaceColOffset = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] interlaceRowIncrement = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] interlaceColIncrement = new int[]{8, 8, 4, 4, 2, 2, 1};

    public PngtasticInterlaceHandler(Logger log, PngFilterHandler pngFilterHandler) {
        this.log = log;
        this.pngFilterHandler = pngFilterHandler;
    }

    @Override
    public List<byte[]> interlace(int width, int height, int sampleBitCount, byte[] inflatedImageData) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<byte[]> deInterlace(int width, int height, int sampleBitCount, PngByteArrayOutputStream inflatedImageData) {
        this.log.debug("Deinterlacing", new Object[0]);
        int sampleSize = Math.max(1, sampleBitCount / 8);
        byte[][] rows = new byte[height][Double.valueOf(Math.ceil((double)(width * sampleBitCount) / 8.0)).intValue() + 1];
        int subImageOffset = 0;
        for (int pass = 0; pass < 7; ++pass) {
            int subImageRows = (height - interlaceRowOffset[pass] + (interlaceRowIncrement[pass] - 1)) / interlaceRowIncrement[pass];
            int subImageCols = (width - interlaceColOffset[pass] + (interlaceColIncrement[pass] - 1)) / interlaceColIncrement[pass];
            int rowLength = Double.valueOf(Math.ceil((double)(subImageCols * sampleBitCount) / 8.0)).intValue() + 1;
            int ci = interlaceColIncrement[pass] * sampleSize;
            int co = interlaceColOffset[pass] * sampleSize;
            int ri = interlaceRowIncrement[pass];
            int ro = interlaceRowOffset[pass];
            byte[] previousRow = new byte[rowLength];
            int offset = 0;
            for (int i = 0; i < subImageRows; ++i) {
                offset = subImageOffset + i * rowLength;
                byte[] row = new byte[rowLength];
                System.arraycopy(inflatedImageData.get(), offset, row, 0, rowLength);
                try {
                    this.pngFilterHandler.deFilter(row, previousRow, sampleBitCount);
                }
                catch (PngException e) {
                    this.log.error("Error: %s", e.getMessage());
                }
                int samples = (row.length - 1) / sampleSize;
                for (int sample = 0; sample < samples; ++sample) {
                    for (int b = 0; b < sampleSize; ++b) {
                        rows[i * ri + ro][sample * ci + co + b + 1] = row[sample * sampleSize + b + 1];
                    }
                }
                previousRow = (byte[])row.clone();
            }
            subImageOffset = offset + rowLength;
        }
        return new ArrayList<byte[]>(Arrays.asList(rows));
    }
}

