/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing.zopfli;

import com.googlecode.pngtastic.core.processing.zopfli.Cookie;
import com.googlecode.pngtastic.core.processing.zopfli.LzStore;
import com.googlecode.pngtastic.core.processing.zopfli.Util;

final class SymbolStats {
    private static final double INV_LOG_2 = 94548.46219969496;
    private final int[] litLens = new int[288];
    private final int[] dists = new int[32];
    final long[] lLiterals = new long[288];
    final long[] lLengths = new long[259];
    final long[] dSymbols = new long[32];

    SymbolStats() {
    }

    void getFreqs(LzStore store) {
        int[] sLitLens = this.litLens;
        int[] sDists = this.dists;
        System.arraycopy(Cookie.intZeroes, 0, sLitLens, 0, 288);
        System.arraycopy(Cookie.intZeroes, 0, sDists, 0, 32);
        int size = store.size;
        char[] litLens = store.litLens;
        char[] dists = store.dists;
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        int[] cachedDistSymbol = Util.CACHED_DIST_SYMBOL;
        for (int i = 0; i < size; ++i) {
            char d = dists[i];
            char l = litLens[i];
            if (d == '\u0000') {
                char c = l;
                sLitLens[c] = sLitLens[c] + 1;
                continue;
            }
            int n = lengthSymbol[l];
            sLitLens[n] = sLitLens[n] + 1;
            int n2 = cachedDistSymbol[d];
            sDists[n2] = sDists[n2] + 1;
        }
        sLitLens[256] = 1;
        this.calculate();
    }

    final void copy(SymbolStats source) {
        System.arraycopy(source.litLens, 0, this.litLens, 0, 288);
        System.arraycopy(source.dists, 0, this.dists, 0, 32);
        System.arraycopy(source.lLiterals, 0, this.lLiterals, 0, 288);
        System.arraycopy(source.lLengths, 0, this.lLengths, 0, 259);
        System.arraycopy(source.dSymbols, 0, this.dSymbols, 0, 32);
    }

    final void calculate() {
        this.calculateLens();
        this.calculateDists();
    }

    private void calculateLens() {
        int sum = 0;
        int[] litLens = this.litLens;
        for (int i = 0; i < 288; ++i) {
            sum += litLens[i];
        }
        double log2sum = (sum == 0 ? Math.log(288.0) : Math.log(sum)) * 94548.46219969496;
        long[] lLiterals = this.lLiterals;
        for (int i = 0; i < 288; ++i) {
            lLiterals[i] = litLens[i] == 0 ? (long)log2sum : Math.max((long)(log2sum - Math.log(litLens[i]) * 94548.46219969496), 0L);
        }
        long[] lLengths = this.lLengths;
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        int[] lengthExtraBits = Util.LENGTH_EXTRA_BITS;
        for (int i = 0; i < 259; ++i) {
            lLengths[i] = lLiterals[lengthSymbol[i]] + (long)lengthExtraBits[i] * 65536L;
        }
    }

    private void calculateDists() {
        int i;
        int sum = 0;
        int[] dists = this.dists;
        for (int i2 = 0; i2 < 32; ++i2) {
            sum += dists[i2];
        }
        double log2sum = (sum == 0 ? Math.log(32.0) : Math.log(sum)) * 94548.46219969496;
        long[] dSymbols = this.dSymbols;
        for (i = 0; i < 32; ++i) {
            dSymbols[i] = dists[i] == 0 ? (long)log2sum : Math.max((long)(log2sum - Math.log(dists[i]) * 94548.46219969496), 0L);
        }
        for (i = 4; i < 30; ++i) {
            int n = i;
            dSymbols[n] = dSymbols[n] + 65536L * (long)(i / 2 - 1);
        }
    }

    final void alloy(SymbolStats ligand) {
        int i;
        for (i = 0; i < 288; ++i) {
            int n = i;
            this.litLens[n] = this.litLens[n] + ligand.litLens[i] / 2;
        }
        this.litLens[256] = 1;
        for (i = 0; i < 32; ++i) {
            int n = i;
            this.dists[n] = this.dists[n] + ligand.dists[i] / 2;
        }
    }

    final int randomizeFreqs(int z) {
        int p;
        int i;
        int[] data = this.litLens;
        int n = data.length;
        for (i = 0; i < n; ++i) {
            if (((z = Integer.MAX_VALUE & 1103515245 * z + 12345) >>> 4) % 3 != 0 || data[i] >= data[p = (z = Integer.MAX_VALUE & 1103515245 * z + 12345) % n]) continue;
            data[i] = data[p];
        }
        data[256] = 1;
        data = this.dists;
        n = data.length;
        for (i = 0; i < n; ++i) {
            if (((z = Integer.MAX_VALUE & 1103515245 * z + 12345) >>> 4) % 3 != 0 || data[i] >= data[p = (z = Integer.MAX_VALUE & 1103515245 * z + 12345) % n]) continue;
            data[i] = data[p];
        }
        return z;
    }

    final long minCost() {
        long[] lLengths = this.lLengths;
        long minLengthCost = lLengths[3];
        for (int i = 4; i < 259; ++i) {
            long c = lLengths[i];
            if (c >= minLengthCost) continue;
            minLengthCost = c;
        }
        long[] dSymbols = this.dSymbols;
        long minDistCost = dSymbols[0];
        for (int i = 1; i < 30; ++i) {
            long c = dSymbols[i];
            if (c >= minDistCost) continue;
            minDistCost = c;
        }
        return minDistCost + minLengthCost;
    }
}

