/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterLoadEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterQueryEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterScanEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.DynamoDBMappingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractDynamoDBEventListener<E>
implements ApplicationListener<DynamoDBMappingEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDynamoDBEventListener.class);
    private final Class<?> domainClass;

    public AbstractDynamoDBEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractDynamoDBEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(DynamoDBMappingEvent<?> event) {
        Object source = event.getSource();
        if (source != null && !this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(source);
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(source);
        } else if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete(source);
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete(source);
        } else if (event instanceof AfterLoadEvent) {
            this.onAfterLoad(source);
        } else if (event instanceof AfterScanEvent) {
            this.onAfterScan(source);
        } else if (event instanceof AfterQueryEvent) {
            this.onAfterQuery(source);
        }
    }

    public void onBeforeSave(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeSave({}, {})", source);
        }
    }

    public void onAfterSave(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterSave({}, {})", source);
        }
    }

    public void onAfterLoad(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterLoad({})", source);
        }
    }

    public void onAfterDelete(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterDelete({})", source);
        }
    }

    public void onBeforeDelete(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeDelete({})", source);
        }
    }

    public void onAfterScan(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterScan({})", source);
        }
    }

    public void onAfterQuery(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterQuery({})", source);
        }
    }
}

