/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.DynamoDBCrudRepository;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.Assert;

public class SimpleDynamoDBCrudRepository<T, ID extends Serializable>
implements DynamoDBCrudRepository<T, ID> {
    protected DynamoDBEntityInformation<T, ID> entityInformation;
    protected Class<T> domainType;
    protected EnableScanPermissions enableScanPermissions;
    protected DynamoDBOperations dynamoDBOperations;

    public SimpleDynamoDBCrudRepository(DynamoDBEntityInformation<T, ID> entityInformation, DynamoDBOperations dynamoDBOperations, EnableScanPermissions enableScanPermissions) {
        Assert.notNull(entityInformation);
        Assert.notNull((Object)dynamoDBOperations);
        this.entityInformation = entityInformation;
        this.dynamoDBOperations = dynamoDBOperations;
        this.domainType = entityInformation.getJavaType();
        this.enableScanPermissions = enableScanPermissions;
    }

    public T findOne(ID id) {
        if (this.entityInformation.isRangeKeyAware()) {
            return this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id), this.entityInformation.getRangeKey(id));
        }
        return this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id));
    }

    public List<T> findAll(Iterable<ID> ids) {
        HashMap keyPairsMap = new HashMap();
        ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
        for (Serializable id : ids) {
            if (this.entityInformation.isRangeKeyAware()) {
                keyPairs.add(new KeyPair().withHashKey(this.entityInformation.getHashKey(id)).withRangeKey(this.entityInformation.getRangeKey(id)));
                continue;
            }
            keyPairs.add(new KeyPair().withHashKey((Object)id));
        }
        keyPairsMap.put(this.domainType, keyPairs);
        return this.dynamoDBOperations.batchLoad(keyPairsMap).get(this.dynamoDBOperations.getOverriddenTableName(this.entityInformation.getDynamoDBTableName()));
    }

    protected T load(ID id) {
        if (this.entityInformation.isRangeKeyAware()) {
            return this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id), this.entityInformation.getRangeKey(id));
        }
        return this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id));
    }

    protected List<T> loadBatch(Iterable<ID> ids) {
        HashMap keyPairsMap = new HashMap();
        ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
        for (Serializable id : ids) {
            if (this.entityInformation.isRangeKeyAware()) {
                keyPairs.add(new KeyPair().withHashKey(this.entityInformation.getHashKey(id)).withRangeKey(this.entityInformation.getRangeKey(id)));
                continue;
            }
            keyPairs.add(new KeyPair().withHashKey((Object)id));
        }
        keyPairsMap.put(this.domainType, keyPairs);
        return this.dynamoDBOperations.batchLoad(keyPairsMap).get(this.domainType);
    }

    public <S extends T> S save(S entity) {
        this.dynamoDBOperations.save(entity);
        return entity;
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        ArrayList<S> entityList = new ArrayList<S>();
        for (S entity : entities) {
            entityList.add(entity);
        }
        this.dynamoDBOperations.batchSave(entityList);
        return entityList;
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.findOne(id) != null;
    }

    public void assertScanEnabled(boolean scanEnabled, String methodName) {
        Assert.isTrue((boolean)scanEnabled, (String)("Scanning for unpaginated " + methodName + "() queries is not enabled.  " + "To enable, re-implement the " + methodName + "() method in your repository interface and annotate with @EnableScan, or " + "enable scanning for all repository methods by annotating your repository interface with @EnableScan"));
    }

    public List<T> findAll() {
        this.assertScanEnabled(this.enableScanPermissions.isFindAllUnpaginatedScanEnabled(), "findAll");
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        return this.dynamoDBOperations.scan(this.domainType, scanExpression);
    }

    public long count() {
        this.assertScanEnabled(this.enableScanPermissions.isCountUnpaginatedScanEnabled(), "count");
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        return this.dynamoDBOperations.count(this.domainType, scanExpression);
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        T entity = this.findOne(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.domainType, id), 1);
        }
        this.dynamoDBOperations.delete(entity);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The entity must not be null!");
        this.dynamoDBOperations.delete(entity);
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        ArrayList<T> entityList = new ArrayList<T>();
        for (T entity : entities) {
            entityList.add(entity);
        }
        this.dynamoDBOperations.batchDelete(entityList);
    }

    public void deleteAll() {
        this.assertScanEnabled(this.enableScanPermissions.isDeleteAllUnpaginatedScanEnabled(), "deleteAll");
        this.dynamoDBOperations.batchDelete((List<?>)this.findAll());
    }
}

