/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.core;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.util.List;
import java.util.Map;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterLoadEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterQueryEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterScanEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.DynamoDBMappingEvent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class DynamoDBTemplate
implements DynamoDBOperations,
ApplicationContextAware {
    protected DynamoDBMapper dynamoDBMapper;
    private AmazonDynamoDB amazonDynamoDB;
    private DynamoDBMapperConfig dynamoDBMapperConfig;
    private ApplicationEventPublisher eventPublisher;

    public DynamoDBTemplate(AmazonDynamoDB amazonDynamoDB, DynamoDBMapperConfig dynamoDBMapperConfig) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.setDynamoDBMapperConfig(dynamoDBMapperConfig);
    }

    public DynamoDBTemplate(AmazonDynamoDB amazonDynamoDB) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.setDynamoDBMapperConfig(null);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    public void setDynamoDBMapperConfig(DynamoDBMapperConfig dynamoDBMapperConfig) {
        this.dynamoDBMapperConfig = dynamoDBMapperConfig;
        DynamoDBMapper dynamoDBMapper = this.dynamoDBMapper = dynamoDBMapperConfig == null ? new DynamoDBMapper(this.amazonDynamoDB) : new DynamoDBMapper(this.amazonDynamoDB, dynamoDBMapperConfig);
        if (dynamoDBMapperConfig == null) {
            this.dynamoDBMapperConfig = DynamoDBMapperConfig.DEFAULT;
        }
    }

    @Override
    public <T> int count(Class<T> domainClass, DynamoDBQueryExpression<T> queryExpression) {
        return this.dynamoDBMapper.count(domainClass, queryExpression);
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> domainClass, DynamoDBQueryExpression<T> queryExpression) {
        PaginatedQueryList results = this.dynamoDBMapper.query(domainClass, queryExpression);
        this.maybeEmitEvent(new AfterQueryEvent(results));
        return results;
    }

    @Override
    public <T> int count(Class<T> domainClass, DynamoDBScanExpression scanExpression) {
        return this.dynamoDBMapper.count(domainClass, scanExpression);
    }

    @Override
    public <T> T load(Class<T> domainClass, Object hashKey, Object rangeKey) {
        Object entity = this.dynamoDBMapper.load(domainClass, hashKey, rangeKey);
        if (entity != null) {
            this.maybeEmitEvent(new AfterLoadEvent<Object>(entity));
        }
        return (T)entity;
    }

    @Override
    public <T> T load(Class<T> domainClass, Object hashKey) {
        Object entity = this.dynamoDBMapper.load(domainClass, hashKey);
        if (entity != null) {
            this.maybeEmitEvent(new AfterLoadEvent<Object>(entity));
        }
        return (T)entity;
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> domainClass, DynamoDBScanExpression scanExpression) {
        PaginatedScanList results = this.dynamoDBMapper.scan(domainClass, scanExpression);
        this.maybeEmitEvent(new AfterScanEvent(results));
        return results;
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        Map results = this.dynamoDBMapper.batchLoad(itemsToGet);
        for (List resultList : results.values()) {
            for (Object entity : resultList) {
                this.maybeEmitEvent(new AfterLoadEvent(entity));
            }
        }
        return results;
    }

    @Override
    public void save(Object entity) {
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(entity));
        this.dynamoDBMapper.save(entity);
        this.maybeEmitEvent(new AfterSaveEvent<Object>(entity));
    }

    @Override
    public void batchSave(List<?> entities) {
        for (Object entity : entities) {
            this.maybeEmitEvent(new BeforeSaveEvent(entity));
        }
        this.dynamoDBMapper.batchSave(entities);
        for (Object entity : entities) {
            this.maybeEmitEvent(new AfterSaveEvent(entity));
        }
    }

    @Override
    public void delete(Object entity) {
        this.maybeEmitEvent(new BeforeDeleteEvent<Object>(entity));
        this.dynamoDBMapper.delete(entity);
        this.maybeEmitEvent(new AfterDeleteEvent<Object>(entity));
    }

    @Override
    public void batchDelete(List<?> entities) {
        for (Object entity : entities) {
            this.maybeEmitEvent(new BeforeDeleteEvent(entity));
        }
        this.dynamoDBMapper.batchDelete(entities);
        for (Object entity : entities) {
            this.maybeEmitEvent(new AfterDeleteEvent(entity));
        }
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, QueryRequest queryRequest) {
        QueryResult queryResult = this.amazonDynamoDB.query(queryRequest);
        return new PaginatedQueryList(this.dynamoDBMapper, clazz, this.amazonDynamoDB, queryRequest, queryResult, this.dynamoDBMapperConfig.getPaginationLoadingStrategy(), this.dynamoDBMapperConfig);
    }

    @Override
    public <T> int count(Class<T> clazz, QueryRequest mutableQueryRequest) {
        mutableQueryRequest.setSelect(Select.COUNT);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.amazonDynamoDB.query(mutableQueryRequest);
            count += queryResult.getCount().intValue();
            mutableQueryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    @Override
    public String getOverriddenTableName(String tableName) {
        if (this.dynamoDBMapperConfig.getTableNameOverride() != null) {
            tableName = this.dynamoDBMapperConfig.getTableNameOverride().getTableName() != null ? this.dynamoDBMapperConfig.getTableNameOverride().getTableName() : this.dynamoDBMapperConfig.getTableNameOverride().getTableNamePrefix() + tableName;
        }
        return tableName;
    }

    protected <T> void maybeEmitEvent(DynamoDBMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }
}

