/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.query;

import java.util.List;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.AbstractQuery;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public abstract class AbstractMultipleEntityQuery<T>
extends AbstractQuery<T>
implements Query<T> {
    public AbstractMultipleEntityQuery(DynamoDBOperations dynamoDBOperations, Class<T> clazz) {
        super(dynamoDBOperations, clazz);
    }

    @Override
    public T getSingleResult() {
        List results = this.getResultList();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException("result returns more than one elements", 1, results.size());
        }
        if (results.size() == 0) {
            throw new EmptyResultDataAccessException("No results found", 1);
        }
        return results.get(0);
    }
}

