/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashKeyExtractingEntityMetadata;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBIdIsHashAndRangeKeyEntityInformationImpl;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBIdIsHashKeyEntityInformationImpl;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DynamoDBEntityMetadataSupport<T, ID extends Serializable>
implements DynamoDBHashKeyExtractingEntityMetadata<T> {
    private final Class<T> domainType;
    private boolean hasRangeKey;
    private String hashKeyPropertyName;
    private List<String> globalIndexHashKeyPropertyNames;
    private List<String> globalIndexRangeKeyPropertyNames;
    private String dynamoDBTableName;
    private Map<String, String[]> globalSecondaryIndexNames = new HashMap<String, String[]>();

    @Override
    public String getDynamoDBTableName() {
        return this.dynamoDBTableName;
    }

    public DynamoDBEntityMetadataSupport(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        this.domainType = domainType;
        DynamoDBTable table = this.domainType.getAnnotation(DynamoDBTable.class);
        Assert.notNull((Object)table, (String)"Domain type must by annotated with DynamoDBTable!");
        this.dynamoDBTableName = table.tableName();
        this.globalSecondaryIndexNames = new HashMap<String, String[]>();
        this.globalIndexHashKeyPropertyNames = new ArrayList<String>();
        this.globalIndexRangeKeyPropertyNames = new ArrayList<String>();
        ReflectionUtils.doWithMethods(domainType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.getAnnotation(DynamoDBHashKey.class) != null) {
                    DynamoDBEntityMetadataSupport.this.hashKeyPropertyName = DynamoDBEntityMetadataSupport.this.getPropertyNameForAccessorMethod(method);
                }
                if (method.getAnnotation(DynamoDBRangeKey.class) != null) {
                    DynamoDBEntityMetadataSupport.this.hasRangeKey = true;
                }
                DynamoDBIndexRangeKey dynamoDBRangeKeyAnnotation = method.getAnnotation(DynamoDBIndexRangeKey.class);
                DynamoDBIndexHashKey dynamoDBHashKeyAnnotation = method.getAnnotation(DynamoDBIndexHashKey.class);
                if (dynamoDBRangeKeyAnnotation != null) {
                    DynamoDBEntityMetadataSupport.this.addGlobalSecondaryIndexNames(method, dynamoDBRangeKeyAnnotation);
                }
                if (dynamoDBHashKeyAnnotation != null) {
                    DynamoDBEntityMetadataSupport.this.addGlobalSecondaryIndexNames(method, dynamoDBHashKeyAnnotation);
                }
            }
        });
        ReflectionUtils.doWithFields(domainType, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(DynamoDBHashKey.class) != null) {
                    DynamoDBEntityMetadataSupport.this.hashKeyPropertyName = DynamoDBEntityMetadataSupport.this.getPropertyNameForField(field);
                }
                if (field.getAnnotation(DynamoDBRangeKey.class) != null) {
                    DynamoDBEntityMetadataSupport.this.hasRangeKey = true;
                }
                DynamoDBIndexRangeKey dynamoDBRangeKeyAnnotation = field.getAnnotation(DynamoDBIndexRangeKey.class);
                DynamoDBIndexHashKey dynamoDBHashKeyAnnotation = field.getAnnotation(DynamoDBIndexHashKey.class);
                if (dynamoDBRangeKeyAnnotation != null) {
                    DynamoDBEntityMetadataSupport.this.addGlobalSecondaryIndexNames(field, dynamoDBRangeKeyAnnotation);
                }
                if (dynamoDBHashKeyAnnotation != null) {
                    DynamoDBEntityMetadataSupport.this.addGlobalSecondaryIndexNames(field, dynamoDBHashKeyAnnotation);
                }
            }
        });
        Assert.notNull((Object)this.hashKeyPropertyName, (String)("Unable to find hash key field or getter method on " + domainType + "!"));
    }

    public DynamoDBEntityInformation<T, ID> getEntityInformation() {
        if (this.hasRangeKey) {
            DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl metadata = new DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl(this.domainType);
            return new DynamoDBIdIsHashAndRangeKeyEntityInformationImpl(this.domainType, metadata);
        }
        return new DynamoDBIdIsHashKeyEntityInformationImpl(this.domainType, this);
    }

    public Class<T> getJavaType() {
        return this.domainType;
    }

    @Override
    public boolean isHashKeyProperty(String propertyName) {
        return this.hashKeyPropertyName.equals(propertyName);
    }

    protected boolean isFieldAnnotatedWith(String propertyName, Class<? extends Annotation> annotation) {
        Field field = this.findField(propertyName);
        return field != null && field.getAnnotation(annotation) != null;
    }

    private String toGetMethodName(String propertyName) {
        String methodName = propertyName.substring(0, 1).toUpperCase();
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        return "get" + methodName;
    }

    protected String toSetterMethodNameFromAccessorMethod(Method method) {
        String accessorMethodName = method.getName();
        if (accessorMethodName.startsWith("get")) {
            return "set" + accessorMethodName.substring(3);
        }
        if (accessorMethodName.startsWith("is")) {
            return "is" + accessorMethodName.substring(2);
        }
        return null;
    }

    private String toIsMethodName(String propertyName) {
        String methodName = propertyName.substring(0, 1).toUpperCase();
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        return "is" + methodName;
    }

    private Method findMethod(String propertyName) {
        Method method = ReflectionUtils.findMethod(this.domainType, (String)this.toGetMethodName(propertyName));
        if (method == null) {
            method = ReflectionUtils.findMethod(this.domainType, (String)this.toIsMethodName(propertyName));
        }
        return method;
    }

    private Field findField(String propertyName) {
        return ReflectionUtils.findField(this.domainType, (String)propertyName);
    }

    public String getOverriddenAttributeName(Method method) {
        if (method != null) {
            if (method.getAnnotation(DynamoDBAttribute.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBAttribute.class).attributeName())) {
                return method.getAnnotation(DynamoDBAttribute.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBHashKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBHashKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBHashKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBRangeKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBRangeKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBRangeKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBIndexRangeKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBIndexRangeKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBIndexRangeKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBIndexHashKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBIndexHashKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBIndexHashKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBVersionAttribute.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBVersionAttribute.class).attributeName())) {
                return method.getAnnotation(DynamoDBVersionAttribute.class).attributeName();
            }
        }
        return null;
    }

    @Override
    public String getOverriddenAttributeName(String propertyName) {
        Field field;
        Method method = this.findMethod(propertyName);
        if (method != null) {
            if (method.getAnnotation(DynamoDBAttribute.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBAttribute.class).attributeName())) {
                return method.getAnnotation(DynamoDBAttribute.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBHashKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBHashKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBHashKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBRangeKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBRangeKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBRangeKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBIndexRangeKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBIndexRangeKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBIndexRangeKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBIndexHashKey.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBIndexHashKey.class).attributeName())) {
                return method.getAnnotation(DynamoDBIndexHashKey.class).attributeName();
            }
            if (method.getAnnotation(DynamoDBVersionAttribute.class) != null && !StringUtils.isEmpty((Object)method.getAnnotation(DynamoDBVersionAttribute.class).attributeName())) {
                return method.getAnnotation(DynamoDBVersionAttribute.class).attributeName();
            }
        }
        if ((field = this.findField(propertyName)) != null) {
            if (field.getAnnotation(DynamoDBAttribute.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBAttribute.class).attributeName())) {
                return field.getAnnotation(DynamoDBAttribute.class).attributeName();
            }
            if (field.getAnnotation(DynamoDBHashKey.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBHashKey.class).attributeName())) {
                return field.getAnnotation(DynamoDBHashKey.class).attributeName();
            }
            if (field.getAnnotation(DynamoDBRangeKey.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBRangeKey.class).attributeName())) {
                return field.getAnnotation(DynamoDBRangeKey.class).attributeName();
            }
            if (field.getAnnotation(DynamoDBIndexRangeKey.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBIndexRangeKey.class).attributeName())) {
                return field.getAnnotation(DynamoDBIndexRangeKey.class).attributeName();
            }
            if (field.getAnnotation(DynamoDBIndexHashKey.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBIndexHashKey.class).attributeName())) {
                return field.getAnnotation(DynamoDBIndexHashKey.class).attributeName();
            }
            if (field.getAnnotation(DynamoDBVersionAttribute.class) != null && !StringUtils.isEmpty((Object)field.getAnnotation(DynamoDBVersionAttribute.class).attributeName())) {
                return field.getAnnotation(DynamoDBVersionAttribute.class).attributeName();
            }
        }
        return null;
    }

    @Override
    public DynamoDBMarshaller<?> getMarshallerForProperty(String propertyName) {
        Method method = this.findMethod(propertyName);
        if (method != null && method.getAnnotation(DynamoDBMarshalling.class) != null) {
            try {
                return (DynamoDBMarshaller)method.getAnnotation(DynamoDBMarshalling.class).marshallerClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected String getPropertyNameForAccessorMethod(Method method) {
        String methodName = method.getName();
        String propertyName = null;
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propertyName = methodName.substring(2);
        }
        Assert.notNull((Object)propertyName, (String)"Hash or range key annotated accessor methods must start with 'get' or 'is'");
        String firstLetter = propertyName.substring(0, 1);
        String remainder = propertyName.substring(1);
        return firstLetter.toLowerCase() + remainder;
    }

    protected String getPropertyNameForField(Field field) {
        return field.getName();
    }

    @Override
    public String getHashKeyPropertyName() {
        return this.hashKeyPropertyName;
    }

    private void addGlobalSecondaryIndexNames(Method method, DynamoDBIndexRangeKey dynamoDBIndexRangeKey) {
        String propertyName;
        if (dynamoDBIndexRangeKey.globalSecondaryIndexNames() != null && dynamoDBIndexRangeKey.globalSecondaryIndexNames().length > 0) {
            propertyName = this.getPropertyNameForAccessorMethod(method);
            this.globalSecondaryIndexNames.put(propertyName, method.getAnnotation(DynamoDBIndexRangeKey.class).globalSecondaryIndexNames());
            this.globalIndexRangeKeyPropertyNames.add(propertyName);
        }
        if (dynamoDBIndexRangeKey.globalSecondaryIndexName() != null && dynamoDBIndexRangeKey.globalSecondaryIndexName().trim().length() > 0) {
            propertyName = this.getPropertyNameForAccessorMethod(method);
            this.globalSecondaryIndexNames.put(propertyName, new String[]{method.getAnnotation(DynamoDBIndexRangeKey.class).globalSecondaryIndexName()});
            this.globalIndexRangeKeyPropertyNames.add(propertyName);
        }
    }

    private void addGlobalSecondaryIndexNames(Field field, DynamoDBIndexRangeKey dynamoDBIndexRangeKey) {
        String propertyName;
        if (dynamoDBIndexRangeKey.globalSecondaryIndexNames() != null && dynamoDBIndexRangeKey.globalSecondaryIndexNames().length > 0) {
            propertyName = this.getPropertyNameForField(field);
            this.globalSecondaryIndexNames.put(propertyName, field.getAnnotation(DynamoDBIndexRangeKey.class).globalSecondaryIndexNames());
            this.globalIndexRangeKeyPropertyNames.add(propertyName);
        }
        if (dynamoDBIndexRangeKey.globalSecondaryIndexName() != null && dynamoDBIndexRangeKey.globalSecondaryIndexName().trim().length() > 0) {
            propertyName = this.getPropertyNameForField(field);
            this.globalSecondaryIndexNames.put(propertyName, new String[]{field.getAnnotation(DynamoDBIndexRangeKey.class).globalSecondaryIndexName()});
            this.globalIndexRangeKeyPropertyNames.add(propertyName);
        }
    }

    private void addGlobalSecondaryIndexNames(Method method, DynamoDBIndexHashKey dynamoDBIndexHashKey) {
        String propertyName;
        if (dynamoDBIndexHashKey.globalSecondaryIndexNames() != null && dynamoDBIndexHashKey.globalSecondaryIndexNames().length > 0) {
            propertyName = this.getPropertyNameForAccessorMethod(method);
            this.globalSecondaryIndexNames.put(propertyName, method.getAnnotation(DynamoDBIndexHashKey.class).globalSecondaryIndexNames());
            this.globalIndexHashKeyPropertyNames.add(propertyName);
        }
        if (dynamoDBIndexHashKey.globalSecondaryIndexName() != null && dynamoDBIndexHashKey.globalSecondaryIndexName().trim().length() > 0) {
            propertyName = this.getPropertyNameForAccessorMethod(method);
            this.globalSecondaryIndexNames.put(propertyName, new String[]{method.getAnnotation(DynamoDBIndexHashKey.class).globalSecondaryIndexName()});
            this.globalIndexHashKeyPropertyNames.add(propertyName);
        }
    }

    private void addGlobalSecondaryIndexNames(Field field, DynamoDBIndexHashKey dynamoDBIndexHashKey) {
        String propertyName;
        if (dynamoDBIndexHashKey.globalSecondaryIndexNames() != null && dynamoDBIndexHashKey.globalSecondaryIndexNames().length > 0) {
            propertyName = this.getPropertyNameForField(field);
            this.globalSecondaryIndexNames.put(propertyName, field.getAnnotation(DynamoDBIndexHashKey.class).globalSecondaryIndexNames());
            this.globalIndexHashKeyPropertyNames.add(propertyName);
        }
        if (dynamoDBIndexHashKey.globalSecondaryIndexName() != null && dynamoDBIndexHashKey.globalSecondaryIndexName().trim().length() > 0) {
            propertyName = this.getPropertyNameForField(field);
            this.globalSecondaryIndexNames.put(propertyName, new String[]{field.getAnnotation(DynamoDBIndexHashKey.class).globalSecondaryIndexName()});
            this.globalIndexHashKeyPropertyNames.add(propertyName);
        }
    }

    @Override
    public Map<String, String[]> getGlobalSecondaryIndexNamesByPropertyName() {
        return this.globalSecondaryIndexNames;
    }

    @Override
    public boolean isGlobalIndexHashKeyProperty(String propertyName) {
        return this.globalIndexHashKeyPropertyNames.contains(propertyName);
    }

    @Override
    public boolean isGlobalIndexRangeKeyProperty(String propertyName) {
        return this.globalIndexRangeKeyPropertyNames.contains(propertyName);
    }
}

