/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.socialsignin.spring.data.dynamodb.repository.support.CompositeIdHashAndRangeKeyExtractor;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityMetadataSupport;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyExtractingEntityMetadata;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyMethodExtractor;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyMethodExtractorImpl;
import org.socialsignin.spring.data.dynamodb.repository.support.HashAndRangeKeyExtractor;
import org.springframework.data.annotation.Id;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl<T, ID extends Serializable>
extends DynamoDBEntityMetadataSupport<T, ID>
implements DynamoDBHashAndRangeKeyExtractingEntityMetadata<T, ID> {
    private DynamoDBHashAndRangeKeyMethodExtractor<T> hashAndRangeKeyMethodExtractor = new DynamoDBHashAndRangeKeyMethodExtractorImpl(this.getJavaType());
    private Method hashKeySetterMethod;
    private Field hashKeyField;

    public DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl(final Class<T> domainType) {
        super(domainType);
        ReflectionUtils.doWithMethods(domainType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                String setterMethodName;
                if (method.getAnnotation(DynamoDBHashKey.class) != null && (setterMethodName = DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl.this.toSetterMethodNameFromAccessorMethod(method)) != null) {
                    DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl.this.hashKeySetterMethod = ReflectionUtils.findMethod((Class)domainType, (String)setterMethodName, (Class[])new Class[]{method.getReturnType()});
                }
            }
        });
        ReflectionUtils.doWithFields(domainType, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(DynamoDBHashKey.class) != null) {
                    DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl.this.hashKeyField = ReflectionUtils.findField((Class)domainType, (String)field.getName());
                }
            }
        });
        Assert.isTrue((this.hashKeySetterMethod != null || this.hashKeyField != null ? 1 : 0) != 0, (String)("Unable to find hash key field or setter method on " + domainType + "!"));
        Assert.isTrue((this.hashKeySetterMethod == null || this.hashKeyField == null ? 1 : 0) != 0, (String)("Found both hash key field and setter method on " + domainType + "!"));
    }

    @Override
    public <H> HashAndRangeKeyExtractor<ID, H> getHashAndRangeKeyExtractor(Class<ID> idClass) {
        return new CompositeIdHashAndRangeKeyExtractor(idClass);
    }

    @Override
    public String getRangeKeyPropertyName() {
        return this.getPropertyNameForAccessorMethod(this.hashAndRangeKeyMethodExtractor.getRangeKeyMethod());
    }

    @Override
    public Set<String> getIndexRangeKeyPropertyNames() {
        final HashSet<String> propertyNames = new HashSet<String>();
        ReflectionUtils.doWithMethods(this.getJavaType(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.getAnnotation(DynamoDBIndexRangeKey.class) != null && (method.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexName() != null && method.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexName().trim().length() > 0 || method.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexNames() != null && method.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexNames().length > 0)) {
                    propertyNames.add(DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl.this.getPropertyNameForAccessorMethod(method));
                }
            }
        });
        ReflectionUtils.doWithFields(this.getJavaType(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(DynamoDBIndexRangeKey.class) != null && (field.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexName() != null && field.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexName().trim().length() > 0 || field.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexNames() != null && field.getAnnotation(DynamoDBIndexRangeKey.class).localSecondaryIndexNames().length > 0)) {
                    propertyNames.add(DynamoDBHashAndRangeKeyExtractingEntityMetadataImpl.this.getPropertyNameForField(field));
                }
            }
        });
        return propertyNames;
    }

    @Override
    public T getHashKeyPropotypeEntityForHashKey(Object hashKey) {
        try {
            Object entity = this.getJavaType().newInstance();
            if (this.hashKeySetterMethod != null) {
                ReflectionUtils.invokeMethod((Method)this.hashKeySetterMethod, entity, (Object[])new Object[]{hashKey});
            } else {
                ReflectionUtils.setField((Field)this.hashKeyField, entity, (Object)hashKey);
            }
            return entity;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isCompositeHashAndRangeKeyProperty(String propertyName) {
        return this.isFieldAnnotatedWith(propertyName, Id.class);
    }
}

