/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.io.Serializable;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.DynamoDBCrudRepository;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryLookupStrategy;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityMetadataSupport;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanAnnotationPermissions;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.socialsignin.spring.data.dynamodb.repository.support.SimpleDynamoDBPagingAndSortingRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;

public class DynamoDBRepositoryFactory
extends RepositoryFactorySupport {
    private final DynamoDBOperations dynamoDBOperations;

    public DynamoDBRepositoryFactory(DynamoDBOperations dynamoDBOperations) {
        this.dynamoDBOperations = dynamoDBOperations;
    }

    public <T, ID extends Serializable> DynamoDBEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        DynamoDBEntityMetadataSupport metadata = new DynamoDBEntityMetadataSupport(domainClass);
        return metadata.getEntityInformation();
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return DynamoDBQueryLookupStrategy.create(this.dynamoDBOperations, key);
    }

    protected <T, ID extends Serializable> DynamoDBCrudRepository<?, ?> getDynamoDBRepository(RepositoryMetadata metadata) {
        return new SimpleDynamoDBPagingAndSortingRepository(this.getEntityInformation(metadata.getDomainType()), this.dynamoDBOperations, this.getEnableScanPermissions(metadata));
    }

    protected EnableScanPermissions getEnableScanPermissions(RepositoryMetadata metadata) {
        return new EnableScanAnnotationPermissions(metadata.getRepositoryInterface());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (DynamoDBRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleDynamoDBPagingAndSortingRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getDynamoDBRepository((RepositoryMetadata)metadata);
    }
}

