/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBMappingContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractDynamoDBConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDynamoDBConfiguration.class);

    public abstract AmazonDynamoDB amazonDynamoDB();

    public abstract AWSCredentials amazonAWSCredentials();

    protected String[] getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        String basePackage = mappingBasePackage == null ? null : mappingBasePackage.getName();
        return new String[]{basePackage};
    }

    @Bean
    public DynamoDBMappingContext dynamoDBMappingContext() throws ClassNotFoundException {
        DynamoDBMappingContext mappingContext = new DynamoDBMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        return mappingContext;
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String[] basePackages;
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : basePackages = this.getMappingBasePackages()) {
            LOGGER.trace("getInitialEntitySet. basePackage: {}", (Object)basePackage);
            if (!StringUtils.hasText((String)basePackage)) continue;
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DynamoDBTable.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                LOGGER.trace("getInitialEntitySet. candidate: {}", (Object)candidate.getBeanClassName());
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AbstractDynamoDBConfiguration.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }
}

