/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.config;

import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBRepositoryFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DynamoDBRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME = "amazonDynamoDB";
    private static final String DYNAMO_DB_MAPPER_CONFIG_REF = "dynamodb-mapper-config-ref";
    private static final String DYNAMO_DB_OPERATIONS_REF = "dynamodb-operations-ref";
    private static final String AMAZON_DYNAMODB_REF = "amazon-dynamodb-ref";

    public String getRepositoryFactoryBeanClassName() {
        return DynamoDBRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        this.postProcess(builder, attributes.getString("amazonDynamoDBRef"), attributes.getString("dynamoDBMapperConfigRef"), attributes.getString("dynamoDBOperationsRef"));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)AMAZON_DYNAMODB_REF, (String)DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME);
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)DYNAMO_DB_MAPPER_CONFIG_REF, (String)"dynamoDBMapperConfig");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)DYNAMO_DB_OPERATIONS_REF, (String)"dynamoDBOperations");
    }

    private void postProcess(BeanDefinitionBuilder builder, String amazonDynamoDBRef, String dynamoDBMapperConfigRef, String dynamoDBOperationsRef) {
        if (StringUtils.hasText((String)dynamoDBOperationsRef)) {
            builder.addPropertyReference("dynamoDBOperations", dynamoDBOperationsRef);
            Assert.isTrue((!StringUtils.hasText((String)amazonDynamoDBRef) ? 1 : 0) != 0, (String)"Cannot specify both amazonDynamoDB bean and dynamoDBOperationsBean in repository configuration");
            Assert.isTrue((!StringUtils.hasText((String)dynamoDBMapperConfigRef) ? 1 : 0) != 0, (String)"Cannot specify both dynamoDBMapperConfigBean bean and dynamoDBOperationsBean in repository configuration");
        } else {
            amazonDynamoDBRef = StringUtils.hasText((String)amazonDynamoDBRef) ? amazonDynamoDBRef : DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME;
            builder.addPropertyReference(DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME, amazonDynamoDBRef);
            if (StringUtils.hasText((String)dynamoDBMapperConfigRef)) {
                builder.addPropertyReference("dynamoDBMapperConfig", dynamoDBMapperConfigRef);
            }
        }
    }

    protected String getModulePrefix() {
        return "dynamoDB";
    }
}

