/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.CountByHashAndRangeKeyQuery;
import org.socialsignin.spring.data.dynamodb.query.MultipleEntityQueryExpressionQuery;
import org.socialsignin.spring.data.dynamodb.query.MultipleEntityQueryRequestQuery;
import org.socialsignin.spring.data.dynamodb.query.MultipleEntityScanExpressionQuery;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.query.QueryExpressionCountQuery;
import org.socialsignin.spring.data.dynamodb.query.QueryRequestCountQuery;
import org.socialsignin.spring.data.dynamodb.query.ScanExpressionCountQuery;
import org.socialsignin.spring.data.dynamodb.query.SingleEntityLoadByHashAndRangeKeyQuery;
import org.socialsignin.spring.data.dynamodb.repository.query.AbstractDynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBIdIsHashAndRangeKeyEntityInformation;
import org.springframework.util.Assert;

public class DynamoDBEntityWithHashAndRangeKeyCriteria<T, ID>
extends AbstractDynamoDBQueryCriteria<T, ID> {
    private Object rangeKeyAttributeValue;
    private Object rangeKeyPropertyValue;
    private String rangeKeyPropertyName;
    private Set<String> indexRangeKeyPropertyNames;
    private DynamoDBIdIsHashAndRangeKeyEntityInformation<T, ID> entityInformation;

    protected String getRangeKeyAttributeName() {
        return this.getAttributeName(this.getRangeKeyPropertyName());
    }

    protected String getRangeKeyPropertyName() {
        return this.rangeKeyPropertyName;
    }

    protected boolean isRangeKeyProperty(String propertyName) {
        return this.rangeKeyPropertyName.equals(propertyName);
    }

    public DynamoDBEntityWithHashAndRangeKeyCriteria(DynamoDBIdIsHashAndRangeKeyEntityInformation<T, ID> entityInformation, DynamoDBMapperTableModel<T> tableModel) {
        super(entityInformation, tableModel);
        this.rangeKeyPropertyName = entityInformation.getRangeKeyPropertyName();
        this.indexRangeKeyPropertyNames = entityInformation.getIndexRangeKeyPropertyNames();
        if (this.indexRangeKeyPropertyNames == null) {
            this.indexRangeKeyPropertyNames = new HashSet<String>();
        }
        this.entityInformation = entityInformation;
    }

    public Set<String> getIndexRangeKeyAttributeNames() {
        HashSet<String> indexRangeKeyAttributeNames = new HashSet<String>();
        for (String indexRangeKeyPropertyName : this.indexRangeKeyPropertyNames) {
            indexRangeKeyAttributeNames.add(this.getAttributeName(indexRangeKeyPropertyName));
        }
        return indexRangeKeyAttributeNames;
    }

    protected Object getRangeKeyAttributeValue() {
        return this.rangeKeyAttributeValue;
    }

    protected Object getRangeKeyPropertyValue() {
        return this.rangeKeyPropertyValue;
    }

    protected boolean isRangeKeySpecified() {
        return this.getRangeKeyAttributeValue() != null;
    }

    @Override
    protected Query<T> buildSingleEntityLoadQuery(DynamoDBOperations dynamoDBOperations) {
        return new SingleEntityLoadByHashAndRangeKeyQuery(dynamoDBOperations, this.entityInformation.getJavaType(), this.getHashKeyPropertyValue(), this.getRangeKeyPropertyValue());
    }

    @Override
    protected Query<Long> buildSingleEntityCountQuery(DynamoDBOperations dynamoDBOperations) {
        return new CountByHashAndRangeKeyQuery(dynamoDBOperations, this.entityInformation.getJavaType(), this.getHashKeyPropertyValue(), this.getRangeKeyPropertyValue());
    }

    private void checkComparisonOperatorPermittedForCompositeHashAndRangeKey(ComparisonOperator comparisonOperator) {
        if (!(ComparisonOperator.EQ.equals((Object)comparisonOperator) || ComparisonOperator.CONTAINS.equals((Object)comparisonOperator) || ComparisonOperator.BEGINS_WITH.equals((Object)comparisonOperator))) {
            throw new UnsupportedOperationException("Only EQ,CONTAINS,BEGINS_WITH supported for composite id comparison");
        }
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withSingleValueCriteria(String propertyName, ComparisonOperator comparisonOperator, Object value, Class<?> propertyType) {
        if (this.entityInformation.isCompositeHashAndRangeKeyProperty(propertyName)) {
            this.checkComparisonOperatorPermittedForCompositeHashAndRangeKey(comparisonOperator);
            Object hashKey = this.entityInformation.getHashKey(value);
            Object rangeKey = this.entityInformation.getRangeKey(value);
            if (hashKey != null) {
                this.withSingleValueCriteria(this.getHashKeyPropertyName(), comparisonOperator, hashKey, hashKey.getClass());
            }
            if (rangeKey != null) {
                this.withSingleValueCriteria(this.getRangeKeyPropertyName(), comparisonOperator, rangeKey, rangeKey.getClass());
            }
            return this;
        }
        return super.withSingleValueCriteria(propertyName, comparisonOperator, value, propertyType);
    }

    public DynamoDBQueryExpression<T> buildQueryExpression() {
        DynamoDBQueryExpression queryExpression = new DynamoDBQueryExpression();
        if (this.isHashKeySpecified()) {
            Object hashKeyPrototype = this.entityInformation.getHashKeyPropotypeEntityForHashKey(this.getHashKeyPropertyValue());
            queryExpression.withHashKeyValues(hashKeyPrototype);
            queryExpression.withRangeKeyConditions(new HashMap());
        }
        if (this.isRangeKeySpecified() && !this.isApplicableForGlobalSecondaryIndex()) {
            Condition rangeKeyCondition = this.createSingleValueCondition(this.getRangeKeyPropertyName(), ComparisonOperator.EQ, this.getRangeKeyAttributeValue(), this.getRangeKeyAttributeValue().getClass(), true);
            queryExpression.withRangeKeyCondition(this.getRangeKeyAttributeName(), rangeKeyCondition);
            this.applySortIfSpecified(queryExpression, Arrays.asList(this.getRangeKeyPropertyName()));
        } else if (this.isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey() || this.isApplicableForGlobalSecondaryIndex()) {
            Map.Entry singlePropertyConditions = (Map.Entry)this.propertyConditions.entrySet().iterator().next();
            ArrayList<String> allowedSortProperties = new ArrayList<String>();
            for (Map.Entry singlePropertyCondition : this.propertyConditions.entrySet()) {
                if (!this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(singlePropertyCondition.getKey())) continue;
                allowedSortProperties.add((String)singlePropertyCondition.getKey());
            }
            if (allowedSortProperties.size() == 0) {
                allowedSortProperties.add((String)singlePropertyConditions.getKey());
            }
            for (Map.Entry singleAttributeConditions : this.attributeConditions.entrySet()) {
                for (Condition condition : (List)singleAttributeConditions.getValue()) {
                    queryExpression.withRangeKeyCondition((String)singleAttributeConditions.getKey(), condition);
                }
            }
            this.applySortIfSpecified(queryExpression, allowedSortProperties);
            if (this.getGlobalSecondaryIndexName() != null) {
                queryExpression.setIndexName(this.getGlobalSecondaryIndexName());
            }
        } else {
            this.applySortIfSpecified(queryExpression, Arrays.asList(this.getRangeKeyPropertyName()));
        }
        return queryExpression;
    }

    protected List<Condition> getRangeKeyConditions() {
        List<Condition> rangeKeyConditions = null;
        if (this.isApplicableForGlobalSecondaryIndex() && this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(this.getRangeKeyPropertyName())) {
            rangeKeyConditions = this.getRangeKeyAttributeValue() == null ? null : Arrays.asList(this.createSingleValueCondition(this.getRangeKeyPropertyName(), ComparisonOperator.EQ, this.getRangeKeyAttributeValue(), this.getRangeKeyAttributeValue().getClass(), true));
        }
        return rangeKeyConditions;
    }

    @Override
    protected Query<T> buildFinderQuery(DynamoDBOperations dynamoDBOperations) {
        if (this.isApplicableForQuery()) {
            if (this.isApplicableForGlobalSecondaryIndex()) {
                String tableName = dynamoDBOperations.getOverriddenTableName(this.clazz, this.entityInformation.getDynamoDBTableName());
                QueryRequest queryRequest = this.buildQueryRequest(tableName, this.getGlobalSecondaryIndexName(), this.getHashKeyAttributeName(), this.getRangeKeyAttributeName(), this.getRangeKeyPropertyName(), this.getHashKeyConditions(), this.getRangeKeyConditions());
                return new MultipleEntityQueryRequestQuery(dynamoDBOperations, this.entityInformation.getJavaType(), queryRequest);
            }
            DynamoDBQueryExpression<T> queryExpression = this.buildQueryExpression();
            return new MultipleEntityQueryExpressionQuery<T>(dynamoDBOperations, this.entityInformation.getJavaType(), queryExpression);
        }
        return new MultipleEntityScanExpressionQuery(dynamoDBOperations, this.clazz, this.buildScanExpression());
    }

    @Override
    protected Query<Long> buildFinderCountQuery(DynamoDBOperations dynamoDBOperations, boolean pageQuery) {
        if (this.isApplicableForQuery()) {
            if (this.isApplicableForGlobalSecondaryIndex()) {
                String tableName = dynamoDBOperations.getOverriddenTableName(this.clazz, this.entityInformation.getDynamoDBTableName());
                QueryRequest queryRequest = this.buildQueryRequest(tableName, this.getGlobalSecondaryIndexName(), this.getHashKeyAttributeName(), this.getRangeKeyAttributeName(), this.getRangeKeyPropertyName(), this.getHashKeyConditions(), this.getRangeKeyConditions());
                return new QueryRequestCountQuery(dynamoDBOperations, queryRequest);
            }
            DynamoDBQueryExpression<T> queryExpression = this.buildQueryExpression();
            return new QueryExpressionCountQuery<T>(dynamoDBOperations, this.entityInformation.getJavaType(), queryExpression);
        }
        return new ScanExpressionCountQuery(dynamoDBOperations, this.clazz, this.buildScanExpression(), pageQuery);
    }

    @Override
    public boolean isApplicableForLoad() {
        return this.attributeConditions.size() == 0 && this.isHashAndRangeKeySpecified();
    }

    protected boolean isHashAndRangeKeySpecified() {
        return this.isHashKeySpecified() && this.isRangeKeySpecified();
    }

    protected boolean isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey() {
        Map.Entry conditionsEntry;
        boolean isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey = false;
        if (!this.isRangeKeySpecified() && this.attributeConditions.size() == 1 && (((String)(conditionsEntry = (Map.Entry)this.attributeConditions.entrySet().iterator().next()).getKey()).equals(this.getRangeKeyAttributeName()) || this.getIndexRangeKeyAttributeNames().contains(conditionsEntry.getKey())) && ((List)conditionsEntry.getValue()).size() == 1) {
            isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey = true;
        }
        return isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey;
    }

    @Override
    protected boolean hasIndexHashKeyEqualCondition() {
        boolean hasCondition = super.hasIndexHashKeyEqualCondition();
        if (!hasCondition && this.rangeKeyAttributeValue != null && this.entityInformation.isGlobalIndexHashKeyProperty(this.rangeKeyPropertyName)) {
            hasCondition = true;
        }
        return hasCondition;
    }

    @Override
    protected boolean hasIndexRangeKeyCondition() {
        boolean hasCondition = super.hasIndexRangeKeyCondition();
        if (!hasCondition && this.rangeKeyAttributeValue != null && this.entityInformation.isGlobalIndexRangeKeyProperty(this.rangeKeyPropertyName)) {
            hasCondition = true;
        }
        return hasCondition;
    }

    @Override
    protected boolean isApplicableForGlobalSecondaryIndex() {
        boolean global = super.isApplicableForGlobalSecondaryIndex();
        if (global && this.getRangeKeyAttributeValue() != null && !this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(this.getRangeKeyPropertyName())) {
            return false;
        }
        return global;
    }

    @Override
    protected String getGlobalSecondaryIndexName() {
        String globalSecondaryIndexName = super.getGlobalSecondaryIndexName();
        if (globalSecondaryIndexName == null && this.hashKeyAttributeValue == null && this.getRangeKeyAttributeValue() != null) {
            String[] rangeKeyIndexNames = this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().get(this.getRangeKeyPropertyName());
            globalSecondaryIndexName = rangeKeyIndexNames != null && rangeKeyIndexNames.length > 0 ? rangeKeyIndexNames[0] : null;
        }
        return globalSecondaryIndexName;
    }

    public boolean isApplicableForQuery() {
        return this.isOnlyHashKeySpecified() || this.isHashKeySpecified() && this.isOnlyASingleAttributeConditionAndItIsOnEitherRangeOrIndexRangeKey() && this.comparisonOperatorsPermittedForQuery() || this.isApplicableForGlobalSecondaryIndex();
    }

    public DynamoDBScanExpression buildScanExpression() {
        this.ensureNoSort(this.sort);
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        if (this.isHashKeySpecified()) {
            scanExpression.addFilterCondition(this.getHashKeyAttributeName(), this.createSingleValueCondition(this.getHashKeyPropertyName(), ComparisonOperator.EQ, this.getHashKeyAttributeValue(), this.getHashKeyAttributeValue().getClass(), true));
        }
        if (this.isRangeKeySpecified()) {
            scanExpression.addFilterCondition(this.getRangeKeyAttributeName(), this.createSingleValueCondition(this.getRangeKeyPropertyName(), ComparisonOperator.EQ, this.getRangeKeyAttributeValue(), this.getRangeKeyAttributeValue().getClass(), true));
        }
        for (Map.Entry conditionEntry : this.attributeConditions.entrySet()) {
            for (Condition condition : (List)conditionEntry.getValue()) {
                scanExpression.addFilterCondition((String)conditionEntry.getKey(), condition);
            }
        }
        return scanExpression;
    }

    public DynamoDBQueryCriteria<T, ID> withRangeKeyEquals(Object value) {
        Assert.notNull((Object)value, (String)("Creating conditions on null range keys not supported: please specify a value for '" + this.getRangeKeyPropertyName() + "'"));
        this.rangeKeyAttributeValue = this.getPropertyAttributeValue(this.getRangeKeyPropertyName(), value);
        this.rangeKeyPropertyValue = value;
        return this;
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withPropertyEquals(String propertyName, Object value, Class<?> propertyType) {
        if (this.isHashKeyProperty(propertyName)) {
            return this.withHashKeyEquals(value);
        }
        if (this.isRangeKeyProperty(propertyName)) {
            return this.withRangeKeyEquals(value);
        }
        if (this.entityInformation.isCompositeHashAndRangeKeyProperty(propertyName)) {
            Assert.notNull((Object)value, (String)("Creating conditions on null composite id properties not supported: please specify a value for '" + propertyName + "'"));
            Object hashKey = this.entityInformation.getHashKey(value);
            Object rangeKey = this.entityInformation.getRangeKey(value);
            if (hashKey != null) {
                this.withHashKeyEquals(hashKey);
            }
            if (rangeKey != null) {
                this.withRangeKeyEquals(rangeKey);
            }
            return this;
        }
        Condition condition = this.createSingleValueCondition(propertyName, ComparisonOperator.EQ, value, propertyType, false);
        return this.withCondition(propertyName, condition);
    }

    @Override
    protected boolean isOnlyHashKeySpecified() {
        return this.isHashKeySpecified() && this.attributeConditions.size() == 0 && !this.isRangeKeySpecified();
    }
}

