/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.repository.EnableScan;
import org.socialsignin.spring.data.dynamodb.repository.EnableScanCount;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityMetadataSupport;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;

public class DynamoDBQueryMethod<T, ID>
extends QueryMethod {
    private final Method method;
    private final boolean scanEnabledForRepository;
    private final boolean scanCountEnabledForRepository;

    public DynamoDBQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.scanEnabledForRepository = metadata.getRepositoryInterface().isAnnotationPresent(EnableScan.class);
        this.scanCountEnabledForRepository = metadata.getRepositoryInterface().isAnnotationPresent(EnableScanCount.class);
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public boolean isScanEnabled() {
        return this.scanEnabledForRepository || this.method.isAnnotationPresent(EnableScan.class);
    }

    public boolean isScanCountEnabled() {
        return this.scanCountEnabledForRepository || this.method.isAnnotationPresent(EnableScanCount.class);
    }

    public DynamoDBEntityInformation<T, ID> getEntityInformation() {
        return new DynamoDBEntityMetadataSupport(this.getDomainClass()).getEntityInformation();
    }

    public Class<T> getEntityType() {
        return this.getEntityInformation().getJavaType();
    }
}

