/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import java.util.Map;
import java.util.Optional;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashKeyExtractingEntityMetadata;
import org.socialsignin.spring.data.dynamodb.repository.support.FieldAndGetterReflectionEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.HashKeyExtractor;
import org.socialsignin.spring.data.dynamodb.repository.support.HashKeyIsIdHashKeyExtractor;
import org.springframework.util.Assert;

public class DynamoDBIdIsHashKeyEntityInformationImpl<T, ID>
extends FieldAndGetterReflectionEntityInformation<T, ID>
implements DynamoDBEntityInformation<T, ID> {
    private DynamoDBHashKeyExtractingEntityMetadata<T> metadata;
    private HashKeyExtractor<ID, ID> hashKeyExtractor;

    public DynamoDBIdIsHashKeyEntityInformationImpl(Class<T> domainClass, DynamoDBHashKeyExtractingEntityMetadata<T> metadata) {
        super(domainClass, DynamoDBHashKey.class);
        this.metadata = metadata;
        this.hashKeyExtractor = new HashKeyIsIdHashKeyExtractor(this.getIdType());
    }

    @Override
    public Object getHashKey(ID id) {
        Assert.isAssignable(this.getIdType(), id.getClass(), (String)("Expected ID type to be the same as the return type of the hash key method ( " + this.getIdType() + " ) : "));
        return this.hashKeyExtractor.getHashKey(id);
    }

    @Override
    public boolean isRangeKeyAware() {
        return false;
    }

    @Override
    public Optional<String> getOverriddenAttributeName(String attributeName) {
        return this.metadata.getOverriddenAttributeName(attributeName);
    }

    @Override
    public boolean isHashKeyProperty(String propertyName) {
        return this.metadata.isHashKeyProperty(propertyName);
    }

    @Override
    public boolean isCompositeHashAndRangeKeyProperty(String propertyName) {
        return false;
    }

    @Override
    public DynamoDBMarshaller<?> getMarshallerForProperty(String propertyName) {
        return this.metadata.getMarshallerForProperty(propertyName);
    }

    @Override
    public Object getRangeKey(ID id) {
        return null;
    }

    @Override
    public String getDynamoDBTableName() {
        return this.metadata.getDynamoDBTableName();
    }

    @Override
    public String getHashKeyPropertyName() {
        return this.metadata.getHashKeyPropertyName();
    }

    @Override
    public Map<String, String[]> getGlobalSecondaryIndexNamesByPropertyName() {
        return this.metadata.getGlobalSecondaryIndexNamesByPropertyName();
    }

    @Override
    public boolean isGlobalIndexHashKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexHashKeyProperty(propertyName);
    }

    @Override
    public boolean isGlobalIndexRangeKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexRangeKeyProperty(propertyName);
    }
}

