/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.util.VersionInfoUtils;
import java.io.Serializable;
import java.util.Optional;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.DynamoDBCrudRepository;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryLookupStrategy;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityMetadataSupport;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanAnnotationPermissions;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.socialsignin.spring.data.dynamodb.repository.support.SimpleDynamoDBPagingAndSortingRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.util.Version;

public class DynamoDBRepositoryFactory
extends RepositoryFactorySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBRepositoryFactory.class);
    private final DynamoDBOperations dynamoDBOperations;

    protected static boolean isCompatible(String spec, String impl) {
        if (spec == null && impl == null) {
            return false;
        }
        if (spec == null) {
            spec = "";
        } else if (impl == null) {
            impl = "";
        }
        StringTokenizer specTokenizer = new StringTokenizer(spec, ".");
        StringTokenizer implTokenizer = new StringTokenizer(impl, ".");
        String specMajor = specTokenizer.hasMoreTokens() ? specTokenizer.nextToken() : "0";
        String specMinor = specTokenizer.hasMoreTokens() ? specTokenizer.nextToken() : "0";
        String implMajor = implTokenizer.hasMoreTokens() ? implTokenizer.nextToken() : "0";
        String implMinor = implTokenizer.hasMoreTokens() ? implTokenizer.nextToken() : "0";
        return specMajor.equals(implMajor) && specMinor.equals(implMinor);
    }

    public DynamoDBRepositoryFactory(DynamoDBOperations dynamoDBOperations) {
        this.dynamoDBOperations = dynamoDBOperations;
    }

    public <T, ID> DynamoDBEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        DynamoDBEntityMetadataSupport metadata = new DynamoDBEntityMetadataSupport(domainClass);
        return metadata.getEntityInformation();
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return Optional.of(DynamoDBQueryLookupStrategy.create(this.dynamoDBOperations, key));
    }

    protected <T, ID extends Serializable> DynamoDBCrudRepository<?, ?> getDynamoDBRepository(RepositoryMetadata metadata) {
        return new SimpleDynamoDBPagingAndSortingRepository(this.getEntityInformation(metadata.getDomainType()), this.dynamoDBOperations, this.getEnableScanPermissions(metadata));
    }

    protected EnableScanPermissions getEnableScanPermissions(RepositoryMetadata metadata) {
        return new EnableScanAnnotationPermissions(metadata.getRepositoryInterface());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (DynamoDBRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleDynamoDBPagingAndSortingRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getDynamoDBRepository((RepositoryMetadata)metadata);
    }

    static {
        String DEVELOPMENT = "DEVELOPMENT";
        String awsSdkVersion = VersionInfoUtils.getVersion();
        String springDataVersion = Version.class.getPackage().getImplementationVersion();
        String thisSpecVersion = DynamoDBRepositoryFactory.class.getPackage().getSpecificationVersion();
        String thisImplVersion = DynamoDBRepositoryFactory.class.getPackage().getImplementationVersion();
        if (thisImplVersion == null || thisSpecVersion == null) {
            thisSpecVersion = "DEVELOPMENT";
            thisImplVersion = "DEVELOPMENT";
        }
        LOGGER.info("Spring Data DynamoDB Version: {} ({})", (Object)thisImplVersion, (Object)thisSpecVersion);
        LOGGER.info("Spring Data Version:          {}", (Object)springDataVersion);
        LOGGER.info("AWS SDK Version:              {}", (Object)awsSdkVersion);
        LOGGER.info("Java Version:                 {} - {} {}", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version")});
        LOGGER.info("Platform Details:             {} {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"));
        if (!"DEVELOPMENT".equals(thisImplVersion) && !DynamoDBRepositoryFactory.isCompatible(springDataVersion, thisSpecVersion)) {
            LOGGER.warn("This Spring Data DynamoDB implementation might not be compatible with the available Spring Data classes on the classpath!" + System.getProperty("line.separator") + "NoDefClassFoundExceptions or similar might occur!");
        }
    }
}

