/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import java.io.Serializable;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBTemplate;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBMappingContext;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBRepositoryFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class DynamoDBRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private DynamoDBMapperConfig dynamoDBMapperConfig;
    private AmazonDynamoDB amazonDynamoDB;
    private DynamoDBOperations dynamoDBOperations;
    private ApplicationContext applicationContext;

    public DynamoDBRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setAmazonDynamoDB(AmazonDynamoDB amazonDynamoDB) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.setMappingContext((MappingContext)new DynamoDBMappingContext());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        if (this.dynamoDBOperations == null) {
            DynamoDBTemplate dynamoDBTemplate = new DynamoDBTemplate(this.amazonDynamoDB, this.dynamoDBMapperConfig);
            dynamoDBTemplate.setApplicationContext(this.applicationContext);
            this.dynamoDBOperations = dynamoDBTemplate;
        }
        return new DynamoDBRepositoryFactory(this.dynamoDBOperations);
    }

    public void setDynamoDBMapperConfig(DynamoDBMapperConfig dynamoDBMapperConfig) {
        this.dynamoDBMapperConfig = dynamoDBMapperConfig;
    }

    public void setDynamoDBOperations(DynamoDBOperations dynamoDBOperations) {
        this.dynamoDBOperations = dynamoDBOperations;
        this.setMappingContext((MappingContext)new DynamoDBMappingContext());
    }
}

