/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleVideoSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleVideoSitemapGenerator
extends SitemapGenerator<GoogleVideoSitemapUrl, GoogleVideoSitemapGenerator> {
    public static SitemapGeneratorBuilder<GoogleVideoSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleVideoSitemapGenerator>(baseUrl, baseDir, GoogleVideoSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleVideoSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleVideoSitemapGenerator>(baseUrl, baseDir, GoogleVideoSitemapGenerator.class);
    }

    GoogleVideoSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleVideoSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleVideoSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleVideoSitemapUrl>
    implements ISitemapUrlRenderer<GoogleVideoSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleVideoSitemapUrl> getUrlClass() {
            return GoogleVideoSitemapUrl.class;
        }

        @Override
        public void render(GoogleVideoSitemapUrl url, OutputStreamWriter out, W3CDateFormat dateFormat) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append("    <video:video>\n");
            this.renderTag(sb, "video", "content_loc", url.getContentUrl());
            if (url.getPlayerUrl() != null) {
                sb.append("      <video:player_loc allow_embed=\"");
                sb.append(url.getAllowEmbed());
                sb.append("\">");
                sb.append(url.getPlayerUrl());
                sb.append("</video:player_loc>\n");
            }
            this.renderTag(sb, "video", "thumbnail_loc", url.getThumbnailUrl());
            this.renderTag(sb, "video", "title", url.getTitle());
            this.renderTag(sb, "video", "description", url.getDescription());
            this.renderTag(sb, "video", "rating", url.getRating());
            this.renderTag(sb, "video", "view_count", url.getViewCount());
            if (url.getPublicationDate() != null) {
                this.renderTag(sb, "video", "publication_date", dateFormat.format(url.getPublicationDate()));
            }
            if (url.getTags() != null) {
                for (String tag : url.getTags()) {
                    this.renderTag(sb, "video", "tag", tag);
                }
            }
            this.renderTag(sb, "video", "category", url.getCategory());
            this.renderTag(sb, "video", "family_friendly", url.getFamilyFriendly());
            this.renderTag(sb, "video", "duration", url.getDurationInSeconds());
            sb.append("    </video:video>\n");
            super.render(url, out, dateFormat, sb.toString());
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:video=\"http://www.google.com/schemas/sitemap-video/1.1\"";
        }
    }
}

